/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.MLModel;
import org.opensearch.ml.common.controller.MLController;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.controller.MLDeployControllerAction;
import org.opensearch.ml.common.transport.controller.MLDeployControllerNodesRequest;
import org.opensearch.ml.common.transport.controller.MLDeployControllerNodesResponse;
import org.opensearch.ml.common.transport.controller.MLUpdateControllerRequest;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.ml.helper.ModelAccessControlHelper;
import org.opensearch.ml.model.MLModelCacheHelper;
import org.opensearch.ml.model.MLModelManager;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class UpdateControllerTransportAction
extends HandledTransportAction<ActionRequest, UpdateResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(UpdateControllerTransportAction.class);
    private final Client client;
    private final MLModelManager mlModelManager;
    private final MLModelCacheHelper mlModelCacheHelper;
    private final ClusterService clusterService;
    private final ModelAccessControlHelper modelAccessControlHelper;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public UpdateControllerTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, ClusterService clusterService, ModelAccessControlHelper modelAccessControlHelper, MLModelCacheHelper mlModelCacheHelper, MLModelManager mlModelManager, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/opensearch/ml/controllers/update", transportService, actionFilters, MLUpdateControllerRequest::new);
        this.client = client;
        this.mlModelManager = mlModelManager;
        this.clusterService = clusterService;
        this.mlModelCacheHelper = mlModelCacheHelper;
        this.modelAccessControlHelper = modelAccessControlHelper;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<UpdateResponse> actionListener) {
        MLUpdateControllerRequest updateControllerRequest = MLUpdateControllerRequest.fromActionRequest((ActionRequest)request);
        MLController updateControllerInput = updateControllerRequest.getUpdateControllerInput();
        String modelId = updateControllerInput.getModelId();
        User user = RestActionUtils.getUserContext(this.client);
        String[] excludes = new String[]{"model_content", "content"};
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            if (!this.mlFeatureEnabledSetting.isControllerEnabled().booleanValue()) {
                throw new IllegalStateException("Controller is currently disabled. To enable it, update the setting \"plugins.ml_commons.controller_enabled\" to true.");
            }
            ActionListener wrappedListener = ActionListener.runBefore(actionListener, () -> ((ThreadContext.StoredContext)context).restore());
            this.mlModelManager.getModel(modelId, null, excludes, (ActionListener<MLModel>)ActionListener.wrap(mlModel -> {
                FunctionName functionName = mlModel.getAlgorithm();
                Boolean isHidden = mlModel.getIsHidden();
                if (functionName == FunctionName.TEXT_EMBEDDING || functionName == FunctionName.REMOTE) {
                    this.modelAccessControlHelper.validateModelGroupAccess(user, mlModel.getModelGroupId(), "cluster:admin/opensearch/ml/controllers/update", this.client, (ActionListener<Boolean>)ActionListener.wrap(hasPermission -> {
                        if (hasPermission.booleanValue()) {
                            this.mlModelManager.getController(modelId, (ActionListener<MLController>)ActionListener.wrap(controller -> {
                                boolean isDeployRequiredAfterUpdate = controller.isDeployRequiredAfterUpdate(updateControllerInput);
                                controller.update(updateControllerInput);
                                this.updateController((MLModel)mlModel, (MLController)controller, isDeployRequiredAfterUpdate, (ActionListener<UpdateResponse>)wrappedListener);
                            }, e -> {
                                if (mlModel.getIsControllerEnabled() == null || !mlModel.getIsControllerEnabled().booleanValue()) {
                                    String errorMsg = StringUtils.getErrorMessage((String)"Model controller haven't been created for the model. Consider calling create model controller api instead.", (String)modelId, (Boolean)isHidden);
                                    wrappedListener.onFailure((Exception)new OpenSearchStatusException(errorMsg, RestStatus.CONFLICT, new Object[0]));
                                    log.error(errorMsg, (Throwable)e);
                                } else {
                                    log.error(e);
                                    wrappedListener.onFailure(e);
                                }
                            }));
                        } else {
                            wrappedListener.onFailure((Exception)new OpenSearchStatusException(StringUtils.getErrorMessage((String)"User doesn't have privilege to perform this operation on this model controller.", (String)modelId, (Boolean)isHidden), RestStatus.FORBIDDEN, new Object[0]));
                        }
                    }, exception -> {
                        log.error(StringUtils.getErrorMessage((String)"Permission denied: Unable to create the model controller for the model. Details: ", (String)modelId, (Boolean)isHidden), (Throwable)exception);
                        wrappedListener.onFailure(exception);
                    }));
                } else {
                    wrappedListener.onFailure((Exception)new OpenSearchStatusException("Creating model controller on this operation on the function category " + functionName.toString() + " is not supported.", RestStatus.FORBIDDEN, new Object[0]));
                }
            }, e -> wrappedListener.onFailure((Exception)new OpenSearchStatusException("Failed to find model to create the corresponding model controller with the provided model ID", RestStatus.NOT_FOUND, new Object[0]))));
        }
        catch (Exception e2) {
            log.error("Failed to create model controller for the provided model", (Throwable)e2);
            actionListener.onFailure(e2);
        }
    }

    private void updateController(MLModel mlModel, MLController controller, boolean isDeployRequiredAfterUpdate, ActionListener<UpdateResponse> actionListener) {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            String modelId = mlModel.getModelId();
            Boolean isHidden = mlModel.getIsHidden();
            ActionListener updateResponseListener = ActionListener.wrap(updateResponse -> {
                if (updateResponse != null && updateResponse.getResult() == DocWriteResponse.Result.UPDATED) {
                    log.info(StringUtils.getErrorMessage((String)"Model controller successfully updated to index, result: {}", (String)modelId, (Boolean)isHidden), (Object)updateResponse.getResult());
                    if (!ArrayUtils.isEmpty((Object[])this.mlModelCacheHelper.getWorkerNodes(modelId)) && isDeployRequiredAfterUpdate) {
                        log.info(StringUtils.getErrorMessage((String)"The model is deployed and the user rate limiter config is constructable. Start to deploy the model controller into cache.", (String)modelId, (Boolean)isHidden));
                        String[] targetNodeIds = this.mlModelManager.getWorkerNodes(modelId, mlModel.getAlgorithm());
                        MLDeployControllerNodesRequest deployControllerNodesRequest = new MLDeployControllerNodesRequest(targetNodeIds, modelId);
                        this.client.execute((ActionType)MLDeployControllerAction.INSTANCE, (ActionRequest)deployControllerNodesRequest, ActionListener.wrap(nodesResponse -> {
                            if (nodesResponse != null && this.isDeployControllerSuccessOnAllNodes((MLDeployControllerNodesResponse)nodesResponse)) {
                                log.info(StringUtils.getErrorMessage((String)"Successfully update model controller and deploy it into cache", (String)modelId, (Boolean)isHidden));
                                actionListener.onResponse(updateResponse);
                            } else {
                                Object[] nodeIds = this.getDeployControllerFailedNodesList((MLDeployControllerNodesResponse)nodesResponse);
                                String errorMessage = StringUtils.getErrorMessage((String)("Successfully update model controller index but deploy model controller to cache was failed on following nodes " + Arrays.toString(nodeIds) + ", please retry."), (String)modelId, (Boolean)isHidden);
                                log.error(errorMessage);
                                actionListener.onFailure((Exception)new RuntimeException(errorMessage));
                            }
                        }, e -> {
                            log.error(StringUtils.getErrorMessage((String)"Failed to deploy model controller for model", (String)modelId, (Boolean)isHidden));
                            actionListener.onFailure(e);
                        }));
                    } else {
                        actionListener.onResponse(updateResponse);
                    }
                } else if (updateResponse != null && updateResponse.getResult() != DocWriteResponse.Result.UPDATED) {
                    log.warn(StringUtils.getErrorMessage((String)"Update model controller got a result status other than update, result status: {}", (String)modelId, (Boolean)isHidden), (Object)updateResponse.getResult());
                    actionListener.onResponse(updateResponse);
                } else {
                    String msg = StringUtils.getErrorMessage((String)"Failed to update model controller.", (String)modelId, (Boolean)isHidden);
                    log.error(msg);
                    actionListener.onFailure((Exception)new RuntimeException(msg));
                }
            }, arg_0 -> actionListener.onFailure(arg_0));
            UpdateRequest updateRequest = new UpdateRequest(".plugins-ml-controller", modelId);
            updateRequest.doc(controller.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS));
            updateRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            this.client.update(updateRequest, ActionListener.runBefore((ActionListener)updateResponseListener, () -> ((ThreadContext.StoredContext)context).restore()));
        }
        catch (Exception e) {
            log.error("Failed to update model controller.", (Throwable)e);
            actionListener.onFailure(e);
        }
    }

    private boolean isDeployControllerSuccessOnAllNodes(MLDeployControllerNodesResponse deployControllerNodesResponse) {
        return deployControllerNodesResponse.failures() == null || deployControllerNodesResponse.failures().isEmpty();
    }

    private String[] getDeployControllerFailedNodesList(MLDeployControllerNodesResponse deployControllerNodesResponse) {
        if (deployControllerNodesResponse == null) {
            return this.getAllNodes();
        }
        ArrayList<String> nodeIds = new ArrayList<String>();
        for (FailedNodeException failedNodeException : deployControllerNodesResponse.failures()) {
            nodeIds.add(failedNodeException.nodeId());
        }
        return nodeIds.toArray(new String[0]);
    }

    private String[] getAllNodes() {
        Iterator iterator = this.clusterService.state().nodes().iterator();
        ArrayList<String> nodeIds = new ArrayList<String>();
        while (iterator.hasNext()) {
            nodeIds.add(((DiscoveryNode)iterator.next()).getId());
        }
        return nodeIds.toArray(new String[0]);
    }
}

