/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.controller;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.nodes.TransportNodesAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.ml.cluster.DiscoveryNodeHelper;
import org.opensearch.ml.common.transport.controller.MLUndeployControllerNodeRequest;
import org.opensearch.ml.common.transport.controller.MLUndeployControllerNodeResponse;
import org.opensearch.ml.common.transport.controller.MLUndeployControllerNodesRequest;
import org.opensearch.ml.common.transport.controller.MLUndeployControllerNodesResponse;
import org.opensearch.ml.helper.ModelAccessControlHelper;
import org.opensearch.ml.model.MLModelManager;
import org.opensearch.ml.stats.MLStats;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class UndeployControllerTransportAction
extends TransportNodesAction<MLUndeployControllerNodesRequest, MLUndeployControllerNodesResponse, MLUndeployControllerNodeRequest, MLUndeployControllerNodeResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(UndeployControllerTransportAction.class);
    private final MLModelManager mlModelManager;
    private final ClusterService clusterService;
    private final Client client;
    private DiscoveryNodeHelper nodeFilter;
    private final MLStats mlStats;
    private NamedXContentRegistry xContentRegistry;
    private ModelAccessControlHelper modelAccessControlHelper;

    @Inject
    public UndeployControllerTransportAction(TransportService transportService, ActionFilters actionFilters, MLModelManager mlModelManager, ClusterService clusterService, ThreadPool threadPool, Client client, DiscoveryNodeHelper nodeFilter, MLStats mlStats, NamedXContentRegistry xContentRegistry, ModelAccessControlHelper modelAccessControlHelper) {
        super("cluster:admin/opensearch/ml/controllers/undeploy", threadPool, clusterService, transportService, actionFilters, MLUndeployControllerNodesRequest::new, MLUndeployControllerNodeRequest::new, "management", MLUndeployControllerNodeResponse.class);
        this.mlModelManager = mlModelManager;
        this.clusterService = clusterService;
        this.client = client;
        this.nodeFilter = nodeFilter;
        this.mlStats = mlStats;
        this.xContentRegistry = xContentRegistry;
        this.modelAccessControlHelper = modelAccessControlHelper;
    }

    protected MLUndeployControllerNodesResponse newResponse(MLUndeployControllerNodesRequest request, List<MLUndeployControllerNodeResponse> responses, List<FailedNodeException> failures) {
        return new MLUndeployControllerNodesResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected MLUndeployControllerNodeRequest newNodeRequest(MLUndeployControllerNodesRequest request) {
        return new MLUndeployControllerNodeRequest(request);
    }

    protected MLUndeployControllerNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new MLUndeployControllerNodeResponse(in);
    }

    protected MLUndeployControllerNodeResponse nodeOperation(MLUndeployControllerNodeRequest request) {
        return this.createUndeployControllerNodeResponse(request.getUndeployControllerNodesRequest());
    }

    private MLUndeployControllerNodeResponse createUndeployControllerNodeResponse(MLUndeployControllerNodesRequest undeployControllerNodesRequest) {
        String modelId = undeployControllerNodesRequest.getModelId();
        HashMap<String, String> controllerUndeployStatus = new HashMap<String, String>();
        controllerUndeployStatus.put(modelId, "received");
        String localNodeId = this.clusterService.localNode().getId();
        this.mlModelManager.undeployController(modelId, (ActionListener<String>)ActionListener.wrap(r -> log.info("Successfully undeployed model controller for the given model on node {}", (Object)localNodeId), e -> log.error("Failed to undeploy model controller for the given model on node {}", (Object)localNodeId, e)));
        return new MLUndeployControllerNodeResponse(this.clusterService.localNode(), controllerUndeployStatus);
    }
}

