/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.CombinedFieldsOperator;
import org.opensearch.client.opensearch._types.query_dsl.CombinedFieldsZeroTerms;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class CombinedFieldsQuery
extends QueryBase
implements QueryVariant,
ToCopyableBuilder<Builder, CombinedFieldsQuery> {
    @Nullable
    private final Boolean autoGenerateSynonymsPhraseQuery;
    @Nonnull
    private final List<String> fields;
    @Nullable
    private final String minimumShouldMatch;
    @Nullable
    private final CombinedFieldsOperator operator;
    @Nonnull
    private final String query;
    @Nullable
    private final CombinedFieldsZeroTerms zeroTermsQuery;
    public static final JsonpDeserializer<CombinedFieldsQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CombinedFieldsQuery::setupCombinedFieldsQueryDeserializer);

    private CombinedFieldsQuery(Builder builder) {
        super(builder);
        this.autoGenerateSynonymsPhraseQuery = builder.autoGenerateSynonymsPhraseQuery;
        this.fields = ApiTypeHelper.unmodifiableRequired(builder.fields, (Object)this, "fields");
        this.minimumShouldMatch = builder.minimumShouldMatch;
        this.operator = builder.operator;
        this.query = ApiTypeHelper.requireNonNull(builder.query, this, "query");
        this.zeroTermsQuery = builder.zeroTermsQuery;
    }

    public static CombinedFieldsQuery of(Function<Builder, ObjectBuilder<CombinedFieldsQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.CombinedFields;
    }

    @Nullable
    public final Boolean autoGenerateSynonymsPhraseQuery() {
        return this.autoGenerateSynonymsPhraseQuery;
    }

    @Nonnull
    public final List<String> fields() {
        return this.fields;
    }

    @Nullable
    public final String minimumShouldMatch() {
        return this.minimumShouldMatch;
    }

    @Nullable
    public final CombinedFieldsOperator operator() {
        return this.operator;
    }

    @Nonnull
    public final String query() {
        return this.query;
    }

    @Nullable
    public final CombinedFieldsZeroTerms zeroTermsQuery() {
        return this.zeroTermsQuery;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.autoGenerateSynonymsPhraseQuery != null) {
            generator.writeKey("auto_generate_synonyms_phrase_query");
            generator.write(this.autoGenerateSynonymsPhraseQuery.booleanValue());
        }
        generator.writeKey("fields");
        generator.writeStartArray();
        for (String item0 : this.fields) {
            generator.write(item0);
        }
        generator.writeEnd();
        if (this.minimumShouldMatch != null) {
            generator.writeKey("minimum_should_match");
            generator.write(this.minimumShouldMatch);
        }
        if (this.operator != null) {
            generator.writeKey("operator");
            this.operator.serialize(generator, mapper);
        }
        generator.writeKey("query");
        generator.write(this.query);
        if (this.zeroTermsQuery != null) {
            generator.writeKey("zero_terms_query");
            this.zeroTermsQuery.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupCombinedFieldsQueryDeserializer(ObjectDeserializer<Builder> op) {
        CombinedFieldsQuery.setupQueryBaseDeserializer(op);
        op.add(Builder::autoGenerateSynonymsPhraseQuery, JsonpDeserializer.booleanDeserializer(), "auto_generate_synonyms_phrase_query");
        op.add(Builder::fields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "fields");
        op.add(Builder::minimumShouldMatch, JsonpDeserializer.stringDeserializer(), "minimum_should_match");
        op.add(Builder::operator, CombinedFieldsOperator._DESERIALIZER, "operator");
        op.add(Builder::query, JsonpDeserializer.stringDeserializer(), "query");
        op.add(Builder::zeroTermsQuery, CombinedFieldsZeroTerms._DESERIALIZER, "zero_terms_query");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.autoGenerateSynonymsPhraseQuery);
        result = 31 * result + this.fields.hashCode();
        result = 31 * result + Objects.hashCode(this.minimumShouldMatch);
        result = 31 * result + Objects.hashCode(this.operator);
        result = 31 * result + this.query.hashCode();
        result = 31 * result + Objects.hashCode(this.zeroTermsQuery);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CombinedFieldsQuery other = (CombinedFieldsQuery)o;
        return Objects.equals(this.autoGenerateSynonymsPhraseQuery, other.autoGenerateSynonymsPhraseQuery) && this.fields.equals(other.fields) && Objects.equals(this.minimumShouldMatch, other.minimumShouldMatch) && Objects.equals(this.operator, other.operator) && this.query.equals(other.query) && Objects.equals(this.zeroTermsQuery, other.zeroTermsQuery);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, CombinedFieldsQuery> {
        @Nullable
        private Boolean autoGenerateSynonymsPhraseQuery;
        private List<String> fields;
        @Nullable
        private String minimumShouldMatch;
        @Nullable
        private CombinedFieldsOperator operator;
        private String query;
        @Nullable
        private CombinedFieldsZeroTerms zeroTermsQuery;

        public Builder() {
        }

        private Builder(CombinedFieldsQuery o) {
            super(o);
            this.autoGenerateSynonymsPhraseQuery = o.autoGenerateSynonymsPhraseQuery;
            this.fields = Builder._listCopy(o.fields);
            this.minimumShouldMatch = o.minimumShouldMatch;
            this.operator = o.operator;
            this.query = o.query;
            this.zeroTermsQuery = o.zeroTermsQuery;
        }

        private Builder(Builder o) {
            super(o);
            this.autoGenerateSynonymsPhraseQuery = o.autoGenerateSynonymsPhraseQuery;
            this.fields = Builder._listCopy(o.fields);
            this.minimumShouldMatch = o.minimumShouldMatch;
            this.operator = o.operator;
            this.query = o.query;
            this.zeroTermsQuery = o.zeroTermsQuery;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder autoGenerateSynonymsPhraseQuery(@Nullable Boolean value) {
            this.autoGenerateSynonymsPhraseQuery = value;
            return this;
        }

        @Nonnull
        public final Builder fields(List<String> list) {
            this.fields = Builder._listAddAll(this.fields, list);
            return this;
        }

        @Nonnull
        public final Builder fields(String value, String ... values) {
            this.fields = Builder._listAdd(this.fields, value, values);
            return this;
        }

        @Nonnull
        public final Builder minimumShouldMatch(@Nullable String value) {
            this.minimumShouldMatch = value;
            return this;
        }

        @Nonnull
        public final Builder operator(@Nullable CombinedFieldsOperator value) {
            this.operator = value;
            return this;
        }

        @Nonnull
        public final Builder query(String value) {
            this.query = value;
            return this;
        }

        @Nonnull
        public final Builder zeroTermsQuery(@Nullable CombinedFieldsZeroTerms value) {
            this.zeroTermsQuery = value;
            return this;
        }

        @Override
        @Nonnull
        public CombinedFieldsQuery build() {
            this._checkSingleUse();
            return new CombinedFieldsQuery(this);
        }
    }
}

