"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _configSchema = require("@osd/config-schema");
var _helpers = require("../services/utils/helpers");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(services, router, dataSourceEnabled) {
  const {
    opensearchService
  } = services;
  router.post({
    path: '/api/alerting/_search',
    validate: {
      body: _configSchema.schema.any(),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, opensearchService.search);
  router.post({
    path: '/api/alerting/_indices',
    validate: {
      body: _configSchema.schema.object({
        index: _configSchema.schema.string()
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, opensearchService.getIndices);
  router.post({
    path: '/api/alerting/_aliases',
    validate: {
      body: _configSchema.schema.object({
        alias: _configSchema.schema.string()
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, opensearchService.getAliases);
  router.post({
    path: '/api/alerting/_mappings',
    validate: {
      body: _configSchema.schema.object({
        index: _configSchema.schema.arrayOf(_configSchema.schema.string())
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, opensearchService.getMappings);
  router.get({
    path: '/api/alerting/_plugins',
    validate: false
  }, opensearchService.getPlugins);
  router.get({
    path: '/api/alerting/_settings',
    validate: false
  }, opensearchService.getSettings);
  router.get({
    path: '/api/alerting/_health',
    validate: false
  }, opensearchService.getClusterHealth);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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