import Redis from "ioredis";
import { RedisIrcConnection } from "./RedisIrcConnection";
import { ConnectionCreateArgs, InCommandPayload, InCommandType } from "./types";
import TypedEmitter from "typed-emitter";
type Events = {
    lostConnection: () => void;
};
declare const IrcPoolClient_base: new () => TypedEmitter<Events>;
export declare class IrcPoolClient extends IrcPoolClient_base {
    private readonly redis;
    private readonly connections;
    shouldRun: boolean;
    private missedHeartbeats;
    private heartbeatInterval?;
    private commandReader;
    cmdReader: Redis;
    constructor(url: string);
    sendCommand<T extends InCommandType>(type: T, payload: InCommandPayload[T]): Promise<void>;
    getPreviouslyConnectedClients(): AsyncGenerator<RedisIrcConnection>;
    createOrGetIrcSocket(clientId: string, netOpts: ConnectionCreateArgs): Promise<RedisIrcConnection>;
    private handleStreamCommand;
    private handleCommand;
    close(): Promise<void>;
    private checkHeartbeat;
    listen(): Promise<void>;
}
export {};
