/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.ArrayList;
import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.type.ManyToOneType;

public final class ManyToOne
extends ToOne {
    private boolean isLogicalOneToOne;
    private NotFoundAction notFoundAction;
    private transient ManyToOneType resolvedType;

    public ManyToOne(MetadataBuildingContext buildingContext, Table table) {
        super(buildingContext, table);
    }

    private ManyToOne(ManyToOne original) {
        super(original);
        this.notFoundAction = original.notFoundAction;
        this.isLogicalOneToOne = original.isLogicalOneToOne;
    }

    @Override
    public ManyToOne copy() {
        return new ManyToOne(this);
    }

    @Override
    public ManyToOneType getType() throws MappingException {
        if (this.resolvedType == null) {
            this.resolvedType = new ManyToOneType(this.getTypeConfiguration(), this.getReferencedEntityName(), this.isReferenceToPrimaryKey(), this.getReferencedPropertyName(), this.getPropertyName(), this.isLazy(), this.isUnwrapProxy(), this.isIgnoreNotFound(), this.isLogicalOneToOne());
        }
        return this.resolvedType;
    }

    @Override
    public void createUniqueKey(MetadataBuildingContext context) {
        if (!this.hasFormula()) {
            this.getTable().createUniqueKey(this.getConstraintColumns(), context);
        }
    }

    public void createPropertyRefConstraints(Map<String, PersistentClass> persistentClasses) {
        if (this.referencedPropertyName != null) {
            this.sortProperties();
            String referencedEntityName = this.getReferencedEntityName();
            String referencedPropertyName = this.getReferencedPropertyName();
            PersistentClass referencedClass = persistentClasses.get(referencedEntityName);
            if (referencedClass == null) {
                throw new MappingException("Referenced entity '" + referencedEntityName + "' does not exist");
            }
            Property property = referencedClass.getReferencedProperty(referencedPropertyName);
            if (property == null) {
                throw new MappingException("Referenced entity '" + referencedEntityName + "' has no property named '" + referencedPropertyName + "'");
            }
            Value value = property.getValue();
            if (value instanceof Component) {
                Component component = (Component)value;
                component.sortProperties();
            }
            if (this.isForeignKeyEnabled() && !this.hasFormula()) {
                ForeignKey foreignKey = this.getTable().createForeignKey(this.getForeignKeyName(), this.getConstraintColumns(), this.getType().getAssociatedEntityName(), this.getForeignKeyDefinition(), this.getForeignKeyOptions(), new ArrayList<Column>(property.getColumns()));
                foreignKey.setReferencedTable(property.getValue().getTable());
                foreignKey.setOnDeleteAction(this.getOnDeleteAction());
            }
        }
    }

    @Override
    public Object accept(ValueVisitor visitor) {
        return visitor.accept(this);
    }

    public NotFoundAction getNotFoundAction() {
        return this.notFoundAction;
    }

    public void setNotFoundAction(NotFoundAction notFoundAction) {
        this.notFoundAction = notFoundAction;
    }

    public boolean isIgnoreNotFound() {
        return this.notFoundAction == NotFoundAction.IGNORE;
    }

    public void setIgnoreNotFound(boolean ignoreNotFound) {
        this.notFoundAction = ignoreNotFound ? NotFoundAction.IGNORE : null;
    }

    public void markAsLogicalOneToOne() {
        this.isLogicalOneToOne = true;
    }

    public boolean isLogicalOneToOne() {
        return this.isLogicalOneToOne;
    }

    @Override
    public boolean isNullable() {
        return this.getReferencedPropertyName() != null || super.isNullable();
    }
}

