/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javajs.J2SIgnoreImport;
import javajs.api.GenericZipInputStream;
import javajs.api.GenericZipTools;
import javajs.api.Interface;
import javajs.api.ZInputStream;
import javajs.util.BArray;
import javajs.util.Lst;
import javajs.util.Rdr;
import javajs.util.SB;
import org.apache.tools.bzip2.CBZip2InputStreamFactory;

@J2SIgnoreImport(value={ZipOutputStream.class})
public class ZipTools
implements GenericZipTools {
    private static byte[] b512;

    @Override
    public ZInputStream newZipInputStream(InputStream is) {
        return (ZInputStream)((Object)ZipTools.newZIS(is));
    }

    private static ZipInputStream newZIS(InputStream is) {
        return is instanceof ZipInputStream ? (ZipInputStream)is : (is instanceof BufferedInputStream ? new GenericZipInputStream(is) : new GenericZipInputStream(new BufferedInputStream(is)));
    }

    @Override
    @Deprecated
    public void getAllZipData(InputStream is, String[] subfileList, String name0, String binaryFileList, String exclude, Map<String, String> fileData) {
    }

    @Override
    public Object getZipFileDirectory(BufferedInputStream bis, String[] list, int listPtr, boolean asBufferedInputStream) {
        String fileName;
        boolean justDir = list == null || listPtr >= list.length;
        String string = fileName = justDir ? "." : list[listPtr];
        if (Rdr.isTar(bis)) {
            return ZipTools.getTarFileDirectory(bis, fileName, asBufferedInputStream);
        }
        if (justDir) {
            return this.getZipDirectoryAsStringAndClose(bis);
        }
        bis = Rdr.getPngZipStream(bis, true);
        ZipInputStream zis = ZipTools.newZIS(bis);
        try {
            ZipEntry ze;
            boolean asBinaryString;
            boolean isAll = fileName.equals(".");
            if (isAll || fileName.lastIndexOf("/") == fileName.length() - 1) {
                ZipEntry ze2;
                SB ret = new SB();
                while ((ze2 = zis.getNextEntry()) != null) {
                    String name = ze2.getName();
                    if (!isAll && !name.startsWith(fileName)) continue;
                    ret.append(name).appendC('\n');
                }
                String str = ret.toString();
                return asBufferedInputStream ? Rdr.getBIS(str.getBytes()) : str;
            }
            int pt = fileName.indexOf(":asBinaryString");
            boolean bl = asBinaryString = pt > 0;
            if (asBinaryString) {
                fileName = fileName.substring(0, pt);
            }
            fileName = fileName.replace('\\', '/');
            while ((ze = zis.getNextEntry()) != null && !fileName.equals(ze.getName())) {
            }
            byte[] bytes = ze == null ? null : Rdr.getLimitedStreamBytes(zis, ze.getSize());
            ze = null;
            zis.close();
            if (bytes == null) {
                return "";
            }
            if (Rdr.isZipB(bytes) || Rdr.isPngZipB(bytes)) {
                return this.getZipFileDirectory(Rdr.getBIS(bytes), list, ++listPtr, asBufferedInputStream);
            }
            if (asBufferedInputStream) {
                return Rdr.getBIS(bytes);
            }
            if (asBinaryString) {
                SB ret = new SB();
                for (int i = 0; i < bytes.length; ++i) {
                    ret.append(Integer.toHexString(bytes[i] & 0xFF)).appendC(' ');
                }
                return ret.toString();
            }
            if (Rdr.isGzipB(bytes)) {
                bytes = Rdr.getLimitedStreamBytes(this.getUnGzippedInputStream(bytes), -1L);
            }
            return Rdr.fixUTF(bytes);
        }
        catch (Exception e) {
            return "";
        }
    }

    private static Object getTarFileDirectory(BufferedInputStream bis, String fileName, boolean asBufferedInputStream) {
        try {
            boolean isAll = fileName.equals(".");
            if (isAll || fileName.lastIndexOf("/") == fileName.length() - 1) {
                SB ret = new SB();
                ZipTools.getTarContents(bis, fileName, ret);
                String str = ret.toString();
                return asBufferedInputStream ? Rdr.getBIS(str.getBytes()) : str;
            }
            fileName = fileName.replace('\\', '/');
            byte[] bytes = ZipTools.getTarContents(bis, fileName, null);
            bis.close();
            return bytes == null ? "" : (asBufferedInputStream ? Rdr.getBIS(bytes) : Rdr.fixUTF(bytes));
        }
        catch (Exception e) {
            return "";
        }
    }

    public byte[] getZipFileContentsAsBytes(BufferedInputStream bis, String[] list, int listPtr) {
        byte[] ret = new byte[]{};
        String fileName = list[listPtr];
        if (fileName.lastIndexOf("/") == fileName.length() - 1) {
            return ret;
        }
        try {
            ZipEntry ze;
            if (Rdr.isTar(bis)) {
                return ZipTools.getTarContents(bis, fileName, null);
            }
            bis = Rdr.getPngZipStream(bis, true);
            ZipInputStream zis = ZipTools.newZIS(bis);
            while ((ze = zis.getNextEntry()) != null) {
                if (!fileName.equals(ze.getName())) continue;
                byte[] bytes = Rdr.getLimitedStreamBytes(zis, ze.getSize());
                return (Rdr.isZipB(bytes) || Rdr.isPngZipB(bytes)) && ++listPtr < list.length ? this.getZipFileContentsAsBytes(Rdr.getBIS(bytes), list, listPtr) : bytes;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    private static byte[] getTarContents(BufferedInputStream bis, String fileName, SB sb) throws IOException {
        if (b512 == null) {
            b512 = new byte[512];
        }
        int len = fileName.length();
        while (bis.read(b512, 0, 512) > 0) {
            byte[] bytes = ZipTools.getTarFile(bis, fileName, len, sb, null, false);
            if (bytes == null) continue;
            return bytes;
        }
        return null;
    }

    private static byte[] getTarFile(BufferedInputStream bis, String fileName, int len, SB sb, Map<String, Object> cache, boolean oneFile) throws IOException {
        int j = 124;
        while (b512[j] == 48) {
            ++j;
        }
        boolean isAll = sb != null && fileName.equals(".");
        int nbytes = 0;
        while (j < 135) {
            nbytes = (nbytes << 3) + (b512[j++] - 48);
        }
        if (nbytes == 0) {
            return null;
        }
        String fname = new String(b512, 0, 100).trim();
        String prefix = new String(b512, 345, 155).trim();
        String name = prefix + fname;
        boolean found = false;
        if (sb != null) {
            if (name.length() == 0) {
                return null;
            }
            if (isAll || (oneFile ? name.equalsIgnoreCase(fileName) : name.startsWith(fileName))) {
                found = cache != null;
                sb.append(name).appendC('\n');
            }
            len = -1;
        }
        int nul = (512 - nbytes % 512) % 512;
        if (!(found || len == name.length() && fileName.equals(name))) {
            int nBlocks;
            int i = nBlocks = nbytes + nul >> 9;
            while (--i >= 0) {
                bis.read(b512, 0, 512);
            }
            return null;
        }
        byte[] bytes = Rdr.getLimitedStreamBytes(bis, nbytes);
        if (cache != null) {
            cache.put(name, new BArray(bytes));
            bis.read(b512, 0, nul);
        }
        return bytes;
    }

    @Override
    public String getZipDirectoryAsStringAndClose(BufferedInputStream bis) {
        SB sb = new SB();
        String[] s = new String[]{};
        try {
            s = this.getZipDirectoryOrErrorAndClose(bis, null);
            bis.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        for (int i = 0; i < s.length; ++i) {
            sb.append(s[i]).appendC('\n');
        }
        return sb.toString();
    }

    @Override
    public String[] getZipDirectoryAndClose(BufferedInputStream bis, String manifestID) {
        String[] s = new String[]{};
        try {
            s = this.getZipDirectoryOrErrorAndClose(bis, manifestID);
            bis.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        return s;
    }

    private String[] getZipDirectoryOrErrorAndClose(BufferedInputStream bis, String manifestID) throws IOException {
        ZipEntry ze;
        bis = Rdr.getPngZipStream(bis, true);
        Lst<String> v = new Lst<String>();
        ZipInputStream zis = ZipTools.newZIS(bis);
        String manifest = null;
        while ((ze = zis.getNextEntry()) != null) {
            String fileName = ze.getName();
            if (manifestID != null && fileName.startsWith(manifestID)) {
                manifest = ZipTools.getStreamAsString(zis);
                continue;
            }
            if (fileName.startsWith("__MACOS")) continue;
            v.addLast(fileName);
        }
        zis.close();
        if (manifestID != null) {
            v.add(0, manifest == null ? "" : manifest + "\n############\n");
        }
        return v.toArray(new String[v.size()]);
    }

    public static String getStreamAsString(InputStream is) throws IOException {
        return Rdr.fixUTF(Rdr.getLimitedStreamBytes(is, -1L));
    }

    @Override
    public InputStream newGZIPInputStream(InputStream is) throws IOException {
        return new BufferedInputStream(new GZIPInputStream(is, 512));
    }

    @Override
    public InputStream newBZip2InputStream(InputStream is) throws IOException {
        return new BufferedInputStream(((CBZip2InputStreamFactory)Interface.getInterface("org.apache.tools.bzip2.CBZip2InputStreamFactory")).getStream(is));
    }

    @Override
    public BufferedInputStream getUnGzippedInputStream(byte[] bytes) {
        try {
            return Rdr.getUnzippedInputStream(this, Rdr.getBIS(bytes));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void addZipEntry(Object zos, String fileName) throws IOException {
        ((ZipOutputStream)zos).putNextEntry(new ZipEntry(fileName));
    }

    @Override
    public void closeZipEntry(Object zos) throws IOException {
        ((ZipOutputStream)zos).closeEntry();
    }

    @Override
    public Object getZipOutputStream(Object bos) {
        return new ZipOutputStream((OutputStream)bos);
    }

    @Override
    public int getCrcValue(byte[] bytes) {
        CRC32 crc = new CRC32();
        crc.update(bytes, 0, bytes.length);
        return (int)crc.getValue();
    }

    @Override
    public void readFileAsMap(BufferedInputStream bis, Map<String, Object> bdata, String name) {
        ZipTools.readFileAsMapStatic(bis, bdata, name);
    }

    private static void readFileAsMapStatic(BufferedInputStream bis, Map<String, Object> bdata, String name) {
        int pt = name == null ? -1 : name.indexOf("|");
        name = pt >= 0 ? name.substring(pt + 1) : null;
        try {
            boolean isZip = false;
            if (Rdr.isPngZipStream(bis)) {
                boolean isImage = "_IMAGE_".equals(name);
                if (name == null || isImage) {
                    bdata.put(isImage ? "_DATA_" : "_IMAGE_", new BArray(ZipTools.getPngImageBytes(bis)));
                }
                isZip = !isImage;
            } else if (Rdr.isZipS(bis)) {
                isZip = true;
            } else if (Rdr.isTar(bis)) {
                ZipTools.cacheTarContentsStatic(bis, name, bdata);
            } else if (name == null) {
                bdata.put("_DATA_", new BArray(Rdr.getLimitedStreamBytes(bis, -1L)));
            } else {
                throw new IOException("ZIP file " + name + " not found");
            }
            if (isZip) {
                ZipTools.cacheZipContentsStatic(bis, name, bdata, true);
            }
            bdata.put("$_BINARY_$", Boolean.TRUE);
        }
        catch (IOException e) {
            bdata.clear();
            bdata.put("_ERROR_", e.getMessage());
        }
    }

    private static String cacheTarContentsStatic(BufferedInputStream bis, String fileName, Map<String, Object> cache) {
        SB listing = new SB();
        long n = 0L;
        if (fileName != null && fileName.endsWith("/.")) {
            fileName = fileName.substring(0, fileName.length() - 1);
        }
        boolean isPath = fileName != null && fileName.endsWith("/");
        boolean justOne = fileName != null && !isPath;
        try {
            if (b512 == null) {
                b512 = new byte[512];
            }
            while (bis.read(b512, 0, 512) > 0) {
                byte[] bytes = ZipTools.getTarFile(bis, fileName == null ? "." : fileName, -1, listing, cache, justOne);
                if (bytes == null) continue;
                n += (long)bytes.length;
                if (!justOne) continue;
                break;
            }
            bis.close();
        }
        catch (Exception e) {
            try {
                bis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
        if (n == 0L || fileName == null) {
            return null;
        }
        System.out.println("ZipTools cached " + n + " bytes from " + fileName);
        return listing.toString();
    }

    @Override
    public String cacheZipContents(BufferedInputStream bis, String fileName, Map<String, Object> cache, boolean asByteArray) {
        return ZipTools.cacheZipContentsStatic(bis, fileName, cache, asByteArray);
    }

    private static String cacheZipContentsStatic(BufferedInputStream bis, String fileName, Map<String, Object> cache, boolean asByteArray) {
        String zipEntryRoot;
        ZipInputStream zis = ZipTools.newZIS(bis);
        SB listing = new SB();
        long n = 0L;
        if (fileName != null && fileName.endsWith("/.")) {
            fileName = fileName.substring(0, fileName.length() - 1);
        }
        boolean isPath = fileName != null && fileName.endsWith("/");
        boolean oneFile = fileName != null && !isPath && asByteArray;
        int pt = oneFile ? fileName.indexOf("|") : -1;
        String string = zipEntryRoot = pt >= 0 ? fileName : null;
        if (pt >= 0) {
            fileName = fileName.substring(0, pt);
        }
        String prefix = fileName == null || isPath ? "" : fileName + "|";
        try {
            ZipEntry ze;
            while ((ze = zis.getNextEntry()) != null) {
                Object object;
                if (ze.isDirectory()) continue;
                String name = ze.getName();
                if (fileName != null) {
                    if (oneFile) {
                        if (!name.equalsIgnoreCase(fileName)) {
                            continue;
                        }
                    } else {
                        if (isPath && !name.startsWith(fileName)) continue;
                        listing.append(name).appendC('\n');
                    }
                }
                long nBytes = ze.getSize();
                byte[] bytes = Rdr.getLimitedStreamBytes(zis, nBytes);
                if (zipEntryRoot != null) {
                    ZipTools.readFileAsMapStatic(Rdr.getBIS(bytes), cache, zipEntryRoot);
                    return null;
                }
                n += (long)bytes.length;
                if (asByteArray) {
                    BArray bArray;
                    object = bArray;
                    bArray = new BArray(bytes);
                } else {
                    object = bytes;
                }
                Object o = object;
                cache.put(oneFile ? "_DATA_" : prefix + name, o);
                if (!oneFile) continue;
                break;
            }
            zis.close();
        }
        catch (Exception e) {
            try {
                zis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
        if (n == 0L || fileName == null) {
            return null;
        }
        System.out.println("ZipTools cached " + n + " bytes from " + fileName);
        return listing.toString();
    }

    private static byte[] getPngImageBytes(BufferedInputStream bis) {
        try {
            if (Rdr.isPngZipStream(bis)) {
                int[] pt_count = new int[2];
                Rdr.getPngZipPointAndCount(bis, pt_count);
                if (pt_count[1] != 0) {
                    return ZipTools.deActivatePngZipB(Rdr.getLimitedStreamBytes(bis, pt_count[0]));
                }
            }
            return Rdr.getLimitedStreamBytes(bis, -1L);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static byte[] deActivatePngZipB(byte[] bytes) {
        if (Rdr.isPngZipB(bytes)) {
            bytes[51] = 32;
        }
        return bytes;
    }

    @Override
    public boolean isZipStream(Object br) {
        return br instanceof ZInputStream;
    }
}

