/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

grayscale reconstruction by erosion of an image


Reconstruction by erosion operates on a "marker" image and a
"mask" image, and is defined as the erosion of the marker image with
respect to the mask image iterated until stability.

The marker image must be less than or equal to the mask image (on a
pixel by pixel basis).

Geodesic morphology is described in Chapter 6.2 of Pierre Soille's
book "Morphological Image Analysis: Principles and Applications",
Second Edition, Springer, 2003.

Algorithm implemented in this filter is based on algorithm described by Kevin
Robinson and Paul F. Whelan in "Efficient Morphological
Reconstruction: A Downhill Filter", Pattern Recognition Letters,
Volume 25, Issue 15, November 2004, Pages 1759-1767.

The algorithm, a description of the transform and some applications
can be found in "Morphological Grayscale Reconstruction in Image
Analysis:  Applications and Efficient Algorithms", Luc Vincent, IEEE
Transactions on image processing, Vol. 2, April 1993.


Richard Beare. Department of Medicine, Monash University, Melbourne,
Australia.

See:
 MorphologyImageFilter , GrayscaleDilateImageFilter , GrayscaleFunctionDilateImageFilter , BinaryDilateImageFilter , ReconstructionByErosionImageFilter , OpeningByReconstructionImageFilter , ClosingByReconstructionImageFilter , ReconstructionImageFilter

 itk::simple::ReconstructionByErosion for the procedural interface

 itk::ReconstructionByErosionImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkReconstructionByErosionImageFilter.h
*/
public class ReconstructionByErosionImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected ReconstructionByErosionImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.ReconstructionByErosionImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(ReconstructionByErosionImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(ReconstructionByErosionImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::ReconstructionByErosionImageFilter::~ReconstructionByErosionImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_ReconstructionByErosionImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::ReconstructionByErosionImageFilter::ReconstructionByErosionImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  ReconstructionByErosionImageFilter() {
    this(SimpleITKJNI.new_ReconstructionByErosionImageFilter(), true);
  }

  /**
Self&amp; itk::simple::ReconstructionByErosionImageFilter::SetFullyConnected(bool FullyConnected)
*/
public  void setFullyConnected(boolean FullyConnected) {
    SimpleITKJNI.ReconstructionByErosionImageFilter_setFullyConnected(swigCPtr, this, FullyConnected);
  }

  /**
Self&amp; itk::simple::ReconstructionByErosionImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public  void fullyConnectedOn() {
    SimpleITKJNI.ReconstructionByErosionImageFilter_fullyConnectedOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ReconstructionByErosionImageFilter::FullyConnectedOff()
*/
public  void fullyConnectedOff() {
    SimpleITKJNI.ReconstructionByErosionImageFilter_fullyConnectedOff(swigCPtr, this);
  }

  /**
bool itk::simple::ReconstructionByErosionImageFilter::GetFullyConnected() const
*/
public  boolean getFullyConnected() {
    return SimpleITKJNI.ReconstructionByErosionImageFilter_getFullyConnected(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ReconstructionByErosionImageFilter::SetUseInternalCopy(bool UseInternalCopy)
*/
public  void setUseInternalCopy(boolean UseInternalCopy) {
    SimpleITKJNI.ReconstructionByErosionImageFilter_setUseInternalCopy(swigCPtr, this, UseInternalCopy);
  }

  /**
Self&amp; itk::simple::ReconstructionByErosionImageFilter::UseInternalCopyOn()

Set the value of UseInternalCopy to true or false respectfully.

*/
public  void useInternalCopyOn() {
    SimpleITKJNI.ReconstructionByErosionImageFilter_useInternalCopyOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ReconstructionByErosionImageFilter::UseInternalCopyOff()
*/
public  void useInternalCopyOff() {
    SimpleITKJNI.ReconstructionByErosionImageFilter_useInternalCopyOff(swigCPtr, this);
  }

  /**
bool itk::simple::ReconstructionByErosionImageFilter::GetUseInternalCopy() const
*/
public  boolean getUseInternalCopy() {
    return SimpleITKJNI.ReconstructionByErosionImageFilter_getUseInternalCopy(swigCPtr, this);
  }

  /**
std::string itk::simple::ReconstructionByErosionImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.ReconstructionByErosionImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::ReconstructionByErosionImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.ReconstructionByErosionImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::ReconstructionByErosionImageFilter::Execute(const Image &amp;markerImage, const Image &amp;maskImage)

Execute the filter on the input image

*/
public  Image execute(Image markerImage, Image maskImage) {
    return new Image(SimpleITKJNI.ReconstructionByErosionImageFilter_execute(swigCPtr, this, Image.getCPtr(markerImage), markerImage, Image.getCPtr(maskImage), maskImage), true);
  }

}
