/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SelfManagingCommenterUtil {
    @Nullable
    public static TextRange getBlockCommentRange(int selectionStart, int selectionEnd, @NotNull Document document, @NotNull String prefix, @NotNull String suffix) {
        if (document == null) {
            SelfManagingCommenterUtil.$$$reportNull$$$0(0);
        }
        if (prefix == null) {
            SelfManagingCommenterUtil.$$$reportNull$$$0(1);
        }
        if (suffix == null) {
            SelfManagingCommenterUtil.$$$reportNull$$$0(2);
        }
        CharSequence sequence = document.getCharsSequence();
        selectionStart = CharArrayUtil.shiftForward(sequence, selectionStart, " \t\n");
        if ((selectionEnd = CharArrayUtil.shiftBackward(sequence, selectionEnd - 1, " \t\n") + 1) < selectionStart) {
            selectionEnd = selectionStart;
        }
        if (CharArrayUtil.regionMatches(sequence, selectionEnd - suffix.length(), suffix) && CharArrayUtil.regionMatches(sequence, selectionStart, prefix)) {
            return new TextRange(selectionStart, selectionEnd);
        }
        return null;
    }

    @NotNull
    public static TextRange insertBlockComment(int startOffset, int endOffset, @NotNull Document document, @NotNull String prefix, @NotNull String suffix) {
        if (document == null) {
            SelfManagingCommenterUtil.$$$reportNull$$$0(3);
        }
        if (prefix == null) {
            SelfManagingCommenterUtil.$$$reportNull$$$0(4);
        }
        if (suffix == null) {
            SelfManagingCommenterUtil.$$$reportNull$$$0(5);
        }
        document.insertString(startOffset, prefix);
        document.insertString(endOffset + prefix.length(), suffix);
        return new TextRange(startOffset, endOffset + prefix.length() + suffix.length());
    }

    public static void uncommentBlockComment(int startOffset, int endOffset, @NotNull Document document, @NotNull String prefix, @NotNull String suffix) {
        if (document == null) {
            SelfManagingCommenterUtil.$$$reportNull$$$0(6);
        }
        if (prefix == null) {
            SelfManagingCommenterUtil.$$$reportNull$$$0(7);
        }
        if (suffix == null) {
            SelfManagingCommenterUtil.$$$reportNull$$$0(8);
        }
        document.deleteString(endOffset - suffix.length(), endOffset);
        document.deleteString(startOffset, startOffset + prefix.length());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/generation/SelfManagingCommenterUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getBlockCommentRange";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "insertBlockComment";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "uncommentBlockComment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

