/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal.prebuilt;

import org.gradle.api.Action;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.artifacts.repositories.RepositoryContentDescriptor;
import org.gradle.api.internal.AbstractNamedDomainObjectContainer;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.collections.DomainObjectCollectionFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.nativeplatform.NativeLibraryBinary;
import org.gradle.nativeplatform.PrebuiltLibraries;
import org.gradle.nativeplatform.PrebuiltLibrary;
import org.gradle.nativeplatform.internal.prebuilt.DefaultPrebuiltLibrary;

public class DefaultPrebuiltLibraries
extends AbstractNamedDomainObjectContainer<PrebuiltLibrary>
implements PrebuiltLibraries {
    private final ObjectFactory objectFactory;
    private final Action<PrebuiltLibrary> libraryInitializer;
    private String name;
    private final DomainObjectCollectionFactory domainObjectCollectionFactory;

    public DefaultPrebuiltLibraries(String name, Instantiator instantiator, ObjectFactory objectFactory, Action<PrebuiltLibrary> libraryInitializer, CollectionCallbackActionDecorator collectionCallbackActionDecorator, DomainObjectCollectionFactory domainObjectCollectionFactory) {
        super(PrebuiltLibrary.class, instantiator, collectionCallbackActionDecorator);
        this.name = name;
        this.objectFactory = objectFactory;
        this.libraryInitializer = libraryInitializer;
        this.domainObjectCollectionFactory = domainObjectCollectionFactory;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void content(Action<? super RepositoryContentDescriptor> configureAction) {
        throw new UnsupportedOperationException();
    }

    protected PrebuiltLibrary doCreate(String name) {
        return (PrebuiltLibrary)this.getInstantiator().newInstance(DefaultPrebuiltLibrary.class, new Object[]{name, this.objectFactory, this.domainObjectCollectionFactory});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrebuiltLibrary resolveLibrary(String name) {
        PrebuiltLibrary library = (PrebuiltLibrary)this.findByName(name);
        if (library != null) {
            DomainObjectSet<NativeLibraryBinary> domainObjectSet = library.getBinaries();
            synchronized (domainObjectSet) {
                if (library.getBinaries().isEmpty()) {
                    this.libraryInitializer.execute((Object)library);
                }
            }
        }
        return library;
    }
}

