/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.codeInsight;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.codeInsight.CustomExceptionHandler;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.GenericsUtil;
import org.jetbrains.kotlin.com.intellij.psi.JavaCodeFragment;
import org.jetbrains.kotlin.com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.LambdaUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCall;
import org.jetbrains.kotlin.com.intellij.psi.PsiCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiCapturedWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCatchSection;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassInitializer;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCodeBlock;
import org.jetbrains.kotlin.com.intellij.psi.PsiDiamondType;
import org.jetbrains.kotlin.com.intellij.psi.PsiDisjunctionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiEnumConstant;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionList;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFunctionalExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiNewExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiResourceList;
import org.jetbrains.kotlin.com.intellij.psi.PsiResourceListElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiTemplateExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiThrowStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiTryStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.AnalysisCanceledException;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.ControlFlow;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.ControlFlowFactory;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.ControlFlowUtil;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiClassImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.infos.MethodCandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.scope.MethodProcessorSetupFailedException;
import org.jetbrains.kotlin.com.intellij.psi.scope.processor.MethodResolverProcessor;
import org.jetbrains.kotlin.com.intellij.psi.scope.util.PsiScopesUtil;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignatureUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTypesUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.BitUtil;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public final class ExceptionUtil {
    @NotNull
    public static List<PsiClassType> getThrownExceptions(PsiElement @NotNull [] elements) {
        if (elements == null) {
            ExceptionUtil.$$$reportNull$$$0(0);
        }
        ArrayList<PsiClassType> array = new ArrayList<PsiClassType>();
        for (PsiElement element : elements) {
            List<PsiClassType> exceptions = ExceptionUtil.getThrownExceptions(element);
            ExceptionUtil.addExceptions(array, exceptions);
        }
        ArrayList<PsiClassType> arrayList = array;
        if (arrayList == null) {
            ExceptionUtil.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public static List<PsiClassType> getThrownExceptions(final @NotNull PsiElement element) {
        if (element == null) {
            ExceptionUtil.$$$reportNull$$$0(7);
        }
        final ArrayList<PsiClassType> result2 = new ArrayList<PsiClassType>();
        class Visitor
        extends JavaRecursiveElementWalkingVisitor {
            Visitor() {
            }

            @Override
            public void visitElement(@NotNull PsiElement psiElement) {
                PsiElement parent2;
                if (psiElement == null) {
                    Visitor.$$$reportNull$$$0(0);
                }
                if (psiElement != element && (parent2 = psiElement.getParent()) instanceof PsiAnonymousClass && !(psiElement instanceof PsiExpressionList)) {
                    return;
                }
                super.visitElement(psiElement);
            }

            @Override
            public void visitAnonymousClass(@NotNull PsiAnonymousClass aClass) {
                if (aClass == null) {
                    Visitor.$$$reportNull$$$0(1);
                }
                this.visitElement(aClass);
            }

            @Override
            public void visitClass(@NotNull PsiClass aClass) {
                if (aClass == null) {
                    Visitor.$$$reportNull$$$0(2);
                }
            }

            @Override
            public void visitTemplateExpression(@NotNull PsiTemplateExpression expression2) {
                if (expression2 == null) {
                    Visitor.$$$reportNull$$$0(3);
                }
                ExceptionUtil.addExceptions(result2, ExceptionUtil.getUnhandledProcessorExceptions(expression2, element));
                super.visitTemplateExpression(expression2);
            }

            @Override
            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
                PsiReferenceExpression methodRef;
                JavaResolveResult resolveResult;
                PsiMethod method;
                if (expression2 == null) {
                    Visitor.$$$reportNull$$$0(4);
                }
                if ((method = (PsiMethod)(resolveResult = (methodRef = expression2.getMethodExpression()).advancedResolve(false)).getElement()) != null) {
                    ExceptionUtil.addExceptions(result2, ExceptionUtil.getExceptionsByMethod(method, resolveResult.getSubstitutor(), element));
                }
                super.visitMethodCallExpression(expression2);
            }

            @Override
            public void visitNewExpression(@NotNull PsiNewExpression expression2) {
                JavaResolveResult resolveResult;
                PsiMethod method;
                if (expression2 == null) {
                    Visitor.$$$reportNull$$$0(5);
                }
                if ((method = (PsiMethod)(resolveResult = expression2.resolveMethodGenerics()).getElement()) != null) {
                    ExceptionUtil.addExceptions(result2, ExceptionUtil.getExceptionsByMethod(method, resolveResult.getSubstitutor(), element));
                }
                super.visitNewExpression(expression2);
            }

            @Override
            public void visitThrowStatement(@NotNull PsiThrowStatement statement) {
                PsiExpression expr;
                if (statement == null) {
                    Visitor.$$$reportNull$$$0(6);
                }
                if ((expr = statement.getException()) != null) {
                    ExceptionUtil.addExceptions(result2, ContainerUtil.filterIsInstance(ExceptionUtil.getPreciseThrowTypes(expr), PsiClassType.class));
                }
                super.visitThrowStatement(statement);
            }

            @Override
            public void visitLambdaExpression(@NotNull PsiLambdaExpression expression2) {
                if (expression2 == null) {
                    Visitor.$$$reportNull$$$0(7);
                }
            }

            @Override
            public void visitResourceList(@NotNull PsiResourceList resourceList) {
                if (resourceList == null) {
                    Visitor.$$$reportNull$$$0(8);
                }
                for (PsiResourceListElement listElement : resourceList) {
                    ExceptionUtil.addExceptions(result2, ExceptionUtil.getCloserExceptions(listElement));
                }
                super.visitResourceList(resourceList);
            }

            @Override
            public void visitTryStatement(@NotNull PsiTryStatement statement) {
                if (statement == null) {
                    Visitor.$$$reportNull$$$0(9);
                }
                ExceptionUtil.addExceptions(result2, ExceptionUtil.getTryExceptions(statement));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "psiElement";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aClass";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 6: 
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "statement";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "resourceList";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/codeInsight/ExceptionUtil$1Visitor";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitAnonymousClass";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClass";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitTemplateExpression";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodCallExpression";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitNewExpression";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitThrowStatement";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitLambdaExpression";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitResourceList";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitTryStatement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        element.accept(new Visitor());
        ArrayList<PsiClassType> arrayList = result2;
        if (arrayList == null) {
            ExceptionUtil.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    private static List<PsiClassType> getTryExceptions(@NotNull PsiTryStatement tryStatement) {
        PsiCodeBlock tryBlock;
        if (tryStatement == null) {
            ExceptionUtil.$$$reportNull$$$0(9);
        }
        ArrayList<PsiClassType> array = new ArrayList<PsiClassType>();
        PsiResourceList resourceList = tryStatement.getResourceList();
        if (resourceList != null) {
            for (PsiResourceListElement psiResourceListElement : resourceList) {
                ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledCloserExceptions(psiResourceListElement, resourceList));
            }
        }
        if ((tryBlock = tryStatement.getTryBlock()) != null) {
            ExceptionUtil.addExceptions(array, ExceptionUtil.getThrownExceptions(tryBlock));
        }
        for (PsiParameter psiParameter : tryStatement.getCatchBlockParameters()) {
            PsiType exception = psiParameter.getType();
            for (int j2 = array.size() - 1; j2 >= 0; --j2) {
                PsiClassType exception1 = (PsiClassType)array.get(j2);
                if (!exception.isAssignableFrom(exception1)) continue;
                array.remove(exception1);
            }
        }
        for (PsiCodeBlock psiCodeBlock : tryStatement.getCatchBlocks()) {
            ExceptionUtil.addExceptions(array, ExceptionUtil.getThrownExceptions(psiCodeBlock));
        }
        PsiCodeBlock psiCodeBlock = tryStatement.getFinallyBlock();
        if (psiCodeBlock != null) {
            try {
                ControlFlow flow = ControlFlowFactory.getInstance(psiCodeBlock.getProject()).getControlFlow(psiCodeBlock, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
                int completionReasons = ControlFlowUtil.getCompletionReasons(flow, 0, flow.getSize());
                List<PsiClassType> list = ExceptionUtil.getThrownExceptions(psiCodeBlock);
                if (!BitUtil.isSet(completionReasons, 1)) {
                    array = new ArrayList<PsiClassType>(list);
                } else {
                    ExceptionUtil.addExceptions(array, list);
                }
            }
            catch (AnalysisCanceledException analysisCanceledException) {
                // empty catch block
            }
        }
        ArrayList<PsiClassType> arrayList = array;
        if (arrayList == null) {
            ExceptionUtil.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    private static List<PsiClassType> getExceptionsByMethod(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor2, @NotNull PsiElement place) {
        PsiClassType[] referenceTypes;
        if (method == null) {
            ExceptionUtil.$$$reportNull$$$0(11);
        }
        if (substitutor2 == null) {
            ExceptionUtil.$$$reportNull$$$0(12);
        }
        if (place == null) {
            ExceptionUtil.$$$reportNull$$$0(13);
        }
        if ((referenceTypes = method.getThrowsList().getReferencedTypes()).length == 0) {
            List<PsiClassType> list = Collections.emptyList();
            if (list == null) {
                ExceptionUtil.$$$reportNull$$$0(14);
            }
            return list;
        }
        GlobalSearchScope scope2 = place.getResolveScope();
        ArrayList<PsiClassType> result2 = new ArrayList<PsiClassType>();
        for (PsiType type : referenceTypes) {
            if ((type = PsiClassImplUtil.correctType(substitutor2.substitute(type), scope2)) instanceof PsiCapturedWildcardType) {
                type = ((PsiCapturedWildcardType)type).getUpperBound();
            }
            if (!(type instanceof PsiClassType)) continue;
            result2.add((PsiClassType)type);
        }
        ArrayList<PsiClassType> arrayList = result2;
        if (arrayList == null) {
            ExceptionUtil.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    private static void addExceptions(@NotNull List<PsiClassType> array, @NotNull Collection<? extends PsiClassType> exceptions) {
        if (array == null) {
            ExceptionUtil.$$$reportNull$$$0(16);
        }
        if (exceptions == null) {
            ExceptionUtil.$$$reportNull$$$0(17);
        }
        for (PsiClassType psiClassType : exceptions) {
            ExceptionUtil.addException(array, psiClassType);
        }
    }

    private static void addException(@NotNull List<PsiClassType> array, @Nullable PsiClassType exception) {
        if (array == null) {
            ExceptionUtil.$$$reportNull$$$0(18);
        }
        if (exception == null) {
            return;
        }
        for (int i2 = array.size() - 1; i2 >= 0; --i2) {
            PsiClassType exception1 = array.get(i2);
            if (exception1.isAssignableFrom(exception)) {
                return;
            }
            if (!exception.isAssignableFrom(exception1)) continue;
            array.remove(i2);
        }
        array.add(exception);
    }

    @NotNull
    public static Collection<PsiClassType> collectUnhandledExceptions(@NotNull PsiElement element, @Nullable PsiElement topElement) {
        if (element == null) {
            ExceptionUtil.$$$reportNull$$$0(22);
        }
        return ExceptionUtil.collectUnhandledExceptions(element, topElement, true);
    }

    @NotNull
    public static Collection<PsiClassType> collectUnhandledExceptions(@NotNull PsiElement element, @Nullable PsiElement topElement, boolean includeSelfCalls) {
        if (element == null) {
            ExceptionUtil.$$$reportNull$$$0(23);
        }
        Set<PsiClassType> set = ContainerUtil.notNullize(ExceptionUtil.collectUnhandledExceptions(element, topElement, null, includeSelfCalls ? c2 -> false : expression2 -> {
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return false;
            }
            return method == PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethod.class);
        }));
        if (set == null) {
            ExceptionUtil.$$$reportNull$$$0(24);
        }
        return set;
    }

    @Nullable
    private static Set<PsiClassType> collectUnhandledExceptions(@NotNull PsiElement element, @Nullable PsiElement topElement, @Nullable Set<PsiClassType> foundExceptions, @NotNull Predicate<? super PsiCall> callFilter) {
        if (element == null) {
            ExceptionUtil.$$$reportNull$$$0(25);
        }
        if (callFilter == null) {
            ExceptionUtil.$$$reportNull$$$0(26);
        }
        Collection<PsiClassType> unhandledExceptions = null;
        if (element instanceof PsiCallExpression) {
            PsiCallExpression expression2 = (PsiCallExpression)element;
            unhandledExceptions = ExceptionUtil.getUnhandledExceptions(expression2, topElement, callFilter);
        } else if (element instanceof PsiTemplateExpression) {
            unhandledExceptions = ExceptionUtil.getUnhandledProcessorExceptions((PsiTemplateExpression)element, topElement);
        } else {
            List<PsiClassType> unhandled;
            if (element instanceof PsiMethodReferenceExpression) {
                PsiExpression qualifierExpression = ((PsiMethodReferenceExpression)element).getQualifierExpression();
                return qualifierExpression != null ? ExceptionUtil.collectUnhandledExceptions(qualifierExpression, topElement, null, callFilter) : null;
            }
            if (element instanceof PsiLambdaExpression) {
                return null;
            }
            if (element instanceof PsiThrowStatement) {
                PsiThrowStatement statement = (PsiThrowStatement)element;
                unhandledExceptions = ExceptionUtil.getUnhandledExceptions(statement, topElement);
            } else if (element instanceof PsiCodeBlock && element.getParent() instanceof PsiMethod && ((PsiMethod)element.getParent()).isConstructor() && !ExceptionUtil.firstStatementIsConstructorCall((PsiCodeBlock)element)) {
                PsiMethod constructor = (PsiMethod)element.getParent();
                PsiClass aClass = constructor.getContainingClass();
                PsiClass superClass = aClass == null ? null : aClass.getSuperClass();
                PsiMethod[] superConstructors = superClass == null ? PsiMethod.EMPTY_ARRAY : superClass.getConstructors();
                HashSet<PsiClassType> unhandled2 = new HashSet<PsiClassType>();
                for (PsiMethod superConstructor : superConstructors) {
                    PsiClassType[] exceptionTypes;
                    if (superConstructor.hasModifierProperty("private") || !superConstructor.getParameterList().isEmpty()) continue;
                    for (PsiClassType exceptionType : exceptionTypes = superConstructor.getThrowsList().getReferencedTypes()) {
                        if (ExceptionUtil.isUncheckedException(exceptionType) || ExceptionUtil.getHandlePlace(element, exceptionType, topElement) != HandlePlace.UNHANDLED) continue;
                        unhandled2.add(exceptionType);
                    }
                    break;
                }
                if (aClass != null) {
                    PsiClassInitializer[] initializers = aClass.getInitializers();
                    HashSet<PsiClassType> thrownByInitializer = new HashSet<PsiClassType>();
                    for (PsiClassInitializer initializer : initializers) {
                        if (initializer.hasModifierProperty("static")) continue;
                        thrownByInitializer.clear();
                        ExceptionUtil.collectUnhandledExceptions(initializer.getBody(), initializer, thrownByInitializer, callFilter);
                        for (PsiClassType thrown : thrownByInitializer) {
                            if (ExceptionUtil.getHandlePlace(constructor.getBody(), thrown, topElement) != HandlePlace.UNHANDLED) continue;
                            unhandled2.add(thrown);
                        }
                    }
                }
                unhandledExceptions = unhandled2;
            } else if (element instanceof PsiResourceListElement && !(unhandled = ExceptionUtil.getUnhandledCloserExceptions((PsiResourceListElement)element, topElement)).isEmpty()) {
                unhandledExceptions = new ArrayList<PsiClassType>(unhandled);
            }
        }
        if (unhandledExceptions != null) {
            if (foundExceptions == null) {
                foundExceptions = new HashSet<PsiClassType>();
            }
            foundExceptions.addAll(unhandledExceptions);
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            Set<PsiClassType> foundInChild = ExceptionUtil.collectUnhandledExceptions(child, topElement, foundExceptions, callFilter);
            if (foundExceptions == null) {
                foundExceptions = foundInChild;
                continue;
            }
            if (foundInChild == null) continue;
            foundExceptions.addAll(foundInChild);
        }
        return foundExceptions;
    }

    @NotNull
    private static List<PsiClassType> getUnhandledExceptions(@NotNull PsiMethodReferenceExpression methodReferenceExpression, PsiElement topElement) {
        JavaResolveResult resolveResult;
        PsiElement resolve;
        if (methodReferenceExpression == null) {
            ExceptionUtil.$$$reportNull$$$0(27);
        }
        if ((resolve = (resolveResult = methodReferenceExpression.advancedResolve(false)).getElement()) instanceof PsiMethod) {
            PsiElement referenceNameElement = methodReferenceExpression.getReferenceNameElement();
            return ExceptionUtil.getUnhandledExceptions((PsiMethod)resolve, referenceNameElement, topElement, resolveResult::getSubstitutor);
        }
        List<PsiClassType> list = Collections.emptyList();
        if (list == null) {
            ExceptionUtil.$$$reportNull$$$0(28);
        }
        return list;
    }

    private static boolean firstStatementIsConstructorCall(@NotNull PsiCodeBlock constructorBody) {
        PsiStatement[] statements;
        if (constructorBody == null) {
            ExceptionUtil.$$$reportNull$$$0(29);
        }
        if ((statements = constructorBody.getStatements()).length == 0) {
            return false;
        }
        if (!(statements[0] instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpression expression2 = ((PsiExpressionStatement)statements[0]).getExpression();
        if (!(expression2 instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethod method = (PsiMethod)((PsiMethodCallExpression)expression2).getMethodExpression().resolve();
        return method != null && method.isConstructor();
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(final PsiElement @NotNull [] elements) {
        if (elements == null) {
            ExceptionUtil.$$$reportNull$$$0(30);
        }
        final ArrayList<PsiClassType> array = new ArrayList<PsiClassType>();
        JavaRecursiveElementWalkingVisitor visitor2 = new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                ExceptionUtil.addExceptions(array, ExceptionUtil.getOwnUnhandledExceptions(element));
                super.visitElement(element);
            }

            @Override
            public void visitLambdaExpression(@NotNull PsiLambdaExpression expression2) {
                if (expression2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (ArrayUtil.find(elements, expression2) >= 0) {
                    this.visitElement(expression2);
                }
            }

            @Override
            public void visitMethodReferenceExpression(@NotNull PsiMethodReferenceExpression expression2) {
                if (expression2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (ArrayUtil.find(elements, expression2) >= 0) {
                    this.visitElement(expression2);
                }
            }

            @Override
            public void visitClass(@NotNull PsiClass aClass) {
                if (aClass == null) {
                    1.$$$reportNull$$$0(3);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aClass";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/codeInsight/ExceptionUtil$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitLambdaExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodReferenceExpression";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClass";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        for (PsiElement element : elements) {
            element.accept(visitor2);
        }
        ArrayList<PsiClassType> arrayList = array;
        if (arrayList == null) {
            ExceptionUtil.$$$reportNull$$$0(31);
        }
        return arrayList;
    }

    @NotNull
    public static List<PsiClassType> getOwnUnhandledExceptions(@NotNull PsiElement element) {
        if (element == null) {
            ExceptionUtil.$$$reportNull$$$0(32);
        }
        if (element instanceof PsiEnumConstant) {
            PsiMethod method = ((PsiEnumConstant)element).resolveMethod();
            if (method != null) {
                return ExceptionUtil.getUnhandledExceptions(method, element, null, () -> PsiSubstitutor.EMPTY);
            }
            List<PsiClassType> list = Collections.emptyList();
            if (list == null) {
                ExceptionUtil.$$$reportNull$$$0(33);
            }
            return list;
        }
        if (element instanceof PsiCallExpression) {
            return ExceptionUtil.getUnhandledExceptions((PsiCallExpression)element, null);
        }
        if (element instanceof PsiThrowStatement) {
            return ExceptionUtil.getUnhandledExceptions((PsiThrowStatement)element, null);
        }
        if (element instanceof PsiMethodReferenceExpression) {
            return ExceptionUtil.getUnhandledExceptions((PsiMethodReferenceExpression)element, null);
        }
        if (element instanceof PsiResourceListElement) {
            return ExceptionUtil.getUnhandledCloserExceptions((PsiResourceListElement)element, null);
        }
        if (element instanceof PsiTemplateExpression) {
            return ExceptionUtil.getUnhandledProcessorExceptions((PsiTemplateExpression)element, null);
        }
        List<PsiClassType> list = Collections.emptyList();
        if (list == null) {
            ExceptionUtil.$$$reportNull$$$0(34);
        }
        return list;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(@NotNull PsiCallExpression methodCall, @Nullable PsiElement topElement) {
        if (methodCall == null) {
            ExceptionUtil.$$$reportNull$$$0(36);
        }
        return ExceptionUtil.getUnhandledExceptions(methodCall, topElement, c2 -> false);
    }

    @NotNull
    private static List<PsiClassType> getUnhandledExceptions(@NotNull PsiCall methodCall, @Nullable PsiElement topElement, @NotNull Predicate<? super PsiCall> skipCondition) {
        PsiMethod method;
        if (methodCall == null) {
            ExceptionUtil.$$$reportNull$$$0(37);
        }
        if (skipCondition == null) {
            ExceptionUtil.$$$reportNull$$$0(38);
        }
        if (MethodCandidateInfo.isOverloadCheck()) {
            List<PsiClassType> list = Collections.emptyList();
            if (list == null) {
                ExceptionUtil.$$$reportNull$$$0(39);
            }
            return list;
        }
        JavaResolveResult result2 = PsiDiamondType.getDiamondsAwareResolveResult(methodCall);
        PsiElement element = result2.getElement();
        PsiMethod psiMethod = method = element instanceof PsiMethod ? (PsiMethod)element : null;
        if (method == null) {
            List<PsiClassType> list = Collections.emptyList();
            if (list == null) {
                ExceptionUtil.$$$reportNull$$$0(40);
            }
            return list;
        }
        if (skipCondition.test(methodCall)) {
            List<PsiClassType> list = Collections.emptyList();
            if (list == null) {
                ExceptionUtil.$$$reportNull$$$0(41);
            }
            return list;
        }
        PsiClassType[] thrownExceptions = method.getThrowsList().getReferencedTypes();
        if (thrownExceptions.length == 0) {
            List<PsiClassType> list = Collections.emptyList();
            if (list == null) {
                ExceptionUtil.$$$reportNull$$$0(42);
            }
            return list;
        }
        List<Pair<PsiMethod, PsiSubstitutor>> otherTargets = methodCall instanceof PsiTemplateExpression ? ExceptionUtil.getTemplateTargets((PsiTemplateExpression)methodCall, method) : (!ExceptionUtil.isArrayClone(method, methodCall) && methodCall instanceof PsiMethodCallExpression ? ExceptionUtil.getMethodCallTargets((PsiMethodCallExpression)methodCall, method) : Collections.emptyList());
        GlobalSearchScope scope2 = methodCall.getResolveScope();
        List<PsiClassType> ex = ExceptionUtil.collectSubstituted(result2.getSubstitutor(), thrownExceptions, scope2);
        for (Pair<PsiMethod, PsiSubstitutor> pair : otherTargets) {
            PsiClassType[] exceptions = ((PsiMethod)pair.first).getThrowsList().getReferencedTypes();
            if (exceptions.length == 0) {
                List<PsiClassType> list = Collections.emptyList();
                if (list == null) {
                    ExceptionUtil.$$$reportNull$$$0(43);
                }
                return list;
            }
            ExceptionUtil.retainExceptions(ex, ExceptionUtil.collectSubstituted((PsiSubstitutor)pair.second, exceptions, scope2));
        }
        List<PsiClassType> list = ExceptionUtil.getUnhandledExceptions(methodCall, topElement, PsiSubstitutor.EMPTY, ex.toArray(PsiClassType.EMPTY_ARRAY));
        if (list == null) {
            ExceptionUtil.$$$reportNull$$$0(44);
        }
        return list;
    }

    private static List<Pair<PsiMethod, PsiSubstitutor>> getMethodCallTargets(@NotNull PsiMethodCallExpression call2, @NotNull PsiMethod method) {
        if (call2 == null) {
            ExceptionUtil.$$$reportNull$$$0(45);
        }
        if (method == null) {
            ExceptionUtil.$$$reportNull$$$0(46);
        }
        PsiFile containingFile = call2.getContainingFile();
        MethodResolverProcessor processor = new MethodResolverProcessor(call2, containingFile);
        try {
            PsiScopesUtil.setupAndRunProcessor(processor, call2, false);
            return ContainerUtil.mapNotNull(processor.getResults(), info -> {
                PsiElement element1 = info.getElement();
                if (info instanceof MethodCandidateInfo && element1 != method && MethodSignatureUtil.areSignaturesEqual(method, (PsiMethod)element1) && !((PsiMethod)element1).hasModifierProperty("private") && !MethodSignatureUtil.isSuperMethod((PsiMethod)element1, method) && (!((MethodCandidateInfo)info).isToInferApplicability() || ((MethodCandidateInfo)info).isApplicable())) {
                    return Pair.create((PsiMethod)element1, ((MethodCandidateInfo)info).getSubstitutor(false));
                }
                return null;
            });
        }
        catch (MethodProcessorSetupFailedException methodProcessorSetupFailedException) {
            return Collections.emptyList();
        }
    }

    private static List<Pair<PsiMethod, PsiSubstitutor>> getTemplateTargets(@NotNull PsiTemplateExpression methodCall, @NotNull PsiMethod baseMethod) {
        PsiExpression processor;
        if (methodCall == null) {
            ExceptionUtil.$$$reportNull$$$0(47);
        }
        if (baseMethod == null) {
            ExceptionUtil.$$$reportNull$$$0(48);
        }
        if ((processor = methodCall.getProcessor()) == null) {
            return Collections.emptyList();
        }
        PsiType type = processor.getType();
        if (type == null) {
            return Collections.emptyList();
        }
        ArrayList<Pair<PsiMethod, PsiSubstitutor>> candidates = new ArrayList<Pair<PsiMethod, PsiSubstitutor>>();
        for (PsiClassType psiClassType : PsiTypesUtil.getClassTypeComponents(type)) {
            PsiClassType.ClassResolveResult resolveResult;
            PsiClass aClass;
            if (!InheritanceUtil.isInheritor(psiClassType, "java.lang.StringTemplate.Processor") || (aClass = (resolveResult = psiClassType.resolveGenerics()).getElement()) == null) continue;
            for (PsiMethod foundMethod : aClass.findMethodsBySignature(baseMethod, true)) {
                PsiSubstitutor substitutor2;
                PsiClass methodContainingClass;
                if (foundMethod == baseMethod || (methodContainingClass = foundMethod.getContainingClass()) == null || (substitutor2 = TypeConversionUtil.getClassSubstitutor(methodContainingClass, aClass, resolveResult.getSubstitutor())) == null) continue;
                candidates.add(Pair.create(foundMethod, substitutor2));
            }
        }
        return candidates;
    }

    public static void retainExceptions(List<PsiClassType> ex, List<? extends PsiClassType> thrownEx) {
        ArrayList<PsiClassType> replacement = new ArrayList<PsiClassType>();
        Iterator<PsiClassType> iterator2 = ex.iterator();
        while (iterator2.hasNext()) {
            PsiClassType classType = iterator2.next();
            boolean found = false;
            for (PsiClassType psiClassType : thrownEx) {
                if (psiClassType.isAssignableFrom(classType)) {
                    found = true;
                    break;
                }
                if (!classType.isAssignableFrom(psiClassType) || ExceptionUtil.isUncheckedException(classType) != ExceptionUtil.isUncheckedException(psiClassType)) continue;
                replacement.add(psiClassType);
            }
            if (found) continue;
            iterator2.remove();
        }
        ex.removeAll(replacement);
        ex.addAll(replacement);
    }

    public static List<PsiClassType> collectSubstituted(PsiSubstitutor substitutor2, PsiClassType[] thrownExceptions, GlobalSearchScope scope2) {
        ArrayList<PsiClassType> ex = new ArrayList<PsiClassType>();
        for (PsiClassType thrownException : thrownExceptions) {
            PsiType upperBound;
            PsiType.Stub capturedWildcardType;
            PsiType psiType = PsiClassImplUtil.correctType(substitutor2.substitute(thrownException), scope2);
            if (psiType instanceof PsiClassType) {
                ex.add((PsiClassType)psiType);
                continue;
            }
            if (psiType instanceof PsiCapturedWildcardType) {
                capturedWildcardType = (PsiCapturedWildcardType)psiType;
                upperBound = ((PsiCapturedWildcardType)capturedWildcardType).getUpperBound();
                if (!(upperBound instanceof PsiClassType)) continue;
                ex.add((PsiClassType)upperBound);
                continue;
            }
            if (!(psiType instanceof PsiWildcardType) || !((upperBound = ((PsiWildcardType)(capturedWildcardType = (PsiWildcardType)psiType)).getExtendsBound()) instanceof PsiClassType)) continue;
            ex.add((PsiClassType)upperBound);
        }
        return ex;
    }

    @NotNull
    public static List<PsiClassType> getCloserExceptions(@NotNull PsiResourceListElement resource) {
        List<PsiClassType> ex;
        if (resource == null) {
            ExceptionUtil.$$$reportNull$$$0(49);
        }
        List<PsiClassType> list = (ex = ExceptionUtil.getExceptionsFromClose(resource)) != null ? ex : Collections.emptyList();
        if (list == null) {
            ExceptionUtil.$$$reportNull$$$0(50);
        }
        return list;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledCloserExceptions(@NotNull PsiResourceListElement resource, @Nullable PsiElement topElement) {
        if (resource == null) {
            ExceptionUtil.$$$reportNull$$$0(51);
        }
        PsiType type = resource.getType();
        return ExceptionUtil.getUnhandledCloserExceptions(resource, topElement, type);
    }

    @NotNull
    public static List<PsiClassType> getUnhandledCloserExceptions(PsiElement place, @Nullable PsiElement topElement, PsiType type) {
        List<PsiClassType> ex = ExceptionUtil.getExceptionsFromClose(type, place.getResolveScope());
        List<PsiClassType> list = ex != null ? ExceptionUtil.getUnhandledExceptions(place, topElement, PsiSubstitutor.EMPTY, ex.toArray(PsiClassType.EMPTY_ARRAY)) : Collections.emptyList();
        if (list == null) {
            ExceptionUtil.$$$reportNull$$$0(52);
        }
        return list;
    }

    private static List<PsiClassType> getExceptionsFromClose(PsiResourceListElement resource) {
        return ExceptionUtil.getExceptionsFromClose(resource.getType(), resource.getResolveScope());
    }

    private static List<PsiClassType> getExceptionsFromClose(PsiType type, GlobalSearchScope scope2) {
        List<PsiClassType> ex = null;
        for (PsiClassType psiClassType : PsiTypesUtil.getClassTypeComponents(type)) {
            PsiMethod[] methods2;
            PsiClassType.ClassResolveResult resourceType = PsiUtil.resolveGenericsClassInType(psiClassType);
            PsiClass resourceClass = resourceType.getElement();
            if (resourceClass == null || (methods2 = PsiUtil.getResourceCloserMethodsForType(psiClassType)) == null) continue;
            for (PsiMethod method : methods2) {
                PsiSubstitutor substitutor2;
                PsiClass closerClass = method.getContainingClass();
                if (closerClass == null || (substitutor2 = TypeConversionUtil.getClassSubstitutor(closerClass, resourceClass, resourceType.getSubstitutor())) == null) continue;
                PsiClassType[] exceptionTypes = method.getThrowsList().getReferencedTypes();
                if (exceptionTypes.length == 0) {
                    return Collections.emptyList();
                }
                if (ex == null) {
                    ex = ExceptionUtil.collectSubstituted(substitutor2, exceptionTypes, scope2);
                    continue;
                }
                ExceptionUtil.retainExceptions(ex, ExceptionUtil.collectSubstituted(substitutor2, exceptionTypes, scope2));
            }
        }
        return ex;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledProcessorExceptions(@NotNull PsiTemplateExpression templateExpression, @Nullable PsiElement topElement) {
        if (templateExpression == null) {
            ExceptionUtil.$$$reportNull$$$0(53);
        }
        if (!PsiUtil.getLanguageLevel(templateExpression).equals((Object)LanguageLevel.JDK_21_PREVIEW)) {
            return ExceptionUtil.getUnhandledExceptions(templateExpression, topElement, c2 -> false);
        }
        PsiExpression processor = templateExpression.getProcessor();
        if (processor == null) {
            List<PsiClassType> list = Collections.emptyList();
            if (list == null) {
                ExceptionUtil.$$$reportNull$$$0(54);
            }
            return list;
        }
        PsiType type = processor.getType();
        ArrayList<PsiClassType> result2 = new ArrayList<PsiClassType>();
        for (PsiClassType psiClassType : PsiTypesUtil.getClassTypeComponents(type)) {
            PsiClassType exceptionType;
            PsiType substituted = PsiUtil.substituteTypeParameter((PsiType)psiClassType, "java.lang.StringTemplate.Processor", 1, false);
            if (substituted instanceof PsiCapturedWildcardType) {
                PsiCapturedWildcardType wildcardType = (PsiCapturedWildcardType)substituted;
                substituted = wildcardType.getUpperBound();
            }
            if (!(substituted instanceof PsiClassType) || ExceptionUtil.isUncheckedException(exceptionType = (PsiClassType)substituted) || ExceptionUtil.getHandlePlace(templateExpression, exceptionType, topElement) != HandlePlace.UNHANDLED) continue;
            result2.add(exceptionType);
        }
        ArrayList<PsiClassType> arrayList = result2;
        if (arrayList == null) {
            ExceptionUtil.$$$reportNull$$$0(55);
        }
        return arrayList;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(@NotNull PsiThrowStatement throwStatement, @Nullable PsiElement topElement) {
        if (throwStatement == null) {
            ExceptionUtil.$$$reportNull$$$0(56);
        }
        SmartList<PsiClassType> unhandled = new SmartList<PsiClassType>();
        for (PsiType type : ExceptionUtil.getPreciseThrowTypes(throwStatement.getException())) {
            List<PsiType> types2 = type instanceof PsiDisjunctionType ? ((PsiDisjunctionType)type).getDisjunctions() : Collections.singletonList(type);
            for (PsiType subType : types2) {
                PsiType upperBound;
                PsiClassType classType = null;
                if (subType instanceof PsiClassType) {
                    classType = (PsiClassType)subType;
                } else if (subType instanceof PsiCapturedWildcardType && (upperBound = ((PsiCapturedWildcardType)subType).getUpperBound()) instanceof PsiClassType) {
                    classType = (PsiClassType)upperBound;
                }
                if (classType == null || ExceptionUtil.isUncheckedException(classType) || ExceptionUtil.getHandlePlace(throwStatement, classType, topElement) != HandlePlace.UNHANDLED) continue;
                unhandled.add(classType);
            }
        }
        SmartList<PsiClassType> smartList = unhandled;
        if (smartList == null) {
            ExceptionUtil.$$$reportNull$$$0(57);
        }
        return smartList;
    }

    @NotNull
    private static List<PsiType> getPreciseThrowTypes(@Nullable PsiExpression expression2) {
        PsiType type;
        PsiElement target;
        if ((expression2 = PsiUtil.skipParenthesizedExprDown(expression2)) instanceof PsiReferenceExpression && (target = ((PsiReferenceExpression)expression2).resolve()) != null && PsiUtil.isCatchParameter(target)) {
            List<PsiType> list = ((PsiCatchSection)target.getParent()).getPreciseCatchTypes();
            if (list == null) {
                ExceptionUtil.$$$reportNull$$$0(58);
            }
            return list;
        }
        if (expression2 != null && (type = expression2.getType()) != null) {
            List<PsiType> list = Collections.singletonList(type);
            if (list == null) {
                ExceptionUtil.$$$reportNull$$$0(59);
            }
            return list;
        }
        List<PsiType> list = Collections.emptyList();
        if (list == null) {
            ExceptionUtil.$$$reportNull$$$0(60);
        }
        return list;
    }

    @NotNull
    private static List<PsiClassType> getUnhandledExceptions(@NotNull PsiMethod method, PsiElement element, PsiElement topElement, @NotNull Supplier<? extends PsiSubstitutor> substitutor2) {
        if (method == null) {
            ExceptionUtil.$$$reportNull$$$0(61);
        }
        if (substitutor2 == null) {
            ExceptionUtil.$$$reportNull$$$0(62);
        }
        if (ExceptionUtil.isArrayClone(method, element)) {
            List<PsiClassType> list = Collections.emptyList();
            if (list == null) {
                ExceptionUtil.$$$reportNull$$$0(63);
            }
            return list;
        }
        PsiClassType[] referencedTypes = method.getThrowsList().getReferencedTypes();
        if (referencedTypes.length == 0) {
            List<PsiClassType> list = Collections.emptyList();
            if (list == null) {
                ExceptionUtil.$$$reportNull$$$0(64);
            }
            return list;
        }
        List<PsiClassType> list = ExceptionUtil.getUnhandledExceptions(element, topElement, substitutor2.get(), referencedTypes);
        if (list == null) {
            ExceptionUtil.$$$reportNull$$$0(65);
        }
        return list;
    }

    private static List<PsiClassType> getUnhandledExceptions(PsiElement element, PsiElement topElement, PsiSubstitutor substitutor2, PsiClassType[] referencedTypes) {
        if (referencedTypes.length > 0) {
            ArrayList<PsiClassType> result2 = new ArrayList<PsiClassType>();
            for (PsiClassType referencedType : referencedTypes) {
                PsiType type = PsiClassImplUtil.correctType(GenericsUtil.eliminateWildcards(substitutor2.substitute(referencedType), false), element.getResolveScope());
                if (!(type instanceof PsiClassType)) continue;
                PsiClassType classType = (PsiClassType)type;
                PsiClass exceptionClass = ((PsiClassType)type).resolve();
                if (exceptionClass == null || ExceptionUtil.isUncheckedException(classType) || ExceptionUtil.getHandlePlace(element, classType, topElement) != HandlePlace.UNHANDLED) continue;
                result2.add((PsiClassType)type);
            }
            return result2;
        }
        return Collections.emptyList();
    }

    private static boolean isArrayClone(@NotNull PsiMethod method, PsiElement element) {
        if (method == null) {
            ExceptionUtil.$$$reportNull$$$0(66);
        }
        if (!method.getName().equals("clone")) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null || !"java.lang.Object".equals(containingClass.getQualifiedName())) {
            return false;
        }
        if (element instanceof PsiMethodReferenceExpression) {
            PsiMethodReferenceExpression methodCallExpression = (PsiMethodReferenceExpression)element;
            PsiExpression qualifierExpression = methodCallExpression.getQualifierExpression();
            return qualifierExpression != null && qualifierExpression.getType() instanceof PsiArrayType;
        }
        if (!(element instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
        PsiExpression qualifierExpression = methodCallExpression.getMethodExpression().getQualifierExpression();
        return qualifierExpression != null && qualifierExpression.getType() instanceof PsiArrayType;
    }

    public static boolean isUncheckedException(@NotNull PsiClassType type) {
        if (type == null) {
            ExceptionUtil.$$$reportNull$$$0(67);
        }
        return InheritanceUtil.isInheritor(type, "java.lang.RuntimeException") || InheritanceUtil.isInheritor(type, "java.lang.Error");
    }

    public static boolean isUncheckedExceptionOrSuperclass(@NotNull PsiClassType type) {
        if (type == null) {
            ExceptionUtil.$$$reportNull$$$0(69);
        }
        return ExceptionUtil.isGeneralExceptionType(type) || ExceptionUtil.isUncheckedException(type);
    }

    public static boolean isGeneralExceptionType(@NotNull PsiType type) {
        if (type == null) {
            ExceptionUtil.$$$reportNull$$$0(70);
        }
        return type.equalsToText("java.lang.Throwable") || type.equalsToText("java.lang.Exception") || type.equalsToText("java.lang.Error");
    }

    @NotNull
    public static HandlePlace getHandlePlace(@Nullable PsiElement element, @NotNull PsiClassType exceptionType, @Nullable PsiElement topElement) {
        PsiClass aClass;
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(73);
        }
        if (element == null || element == topElement) {
            HandlePlace handlePlace = HandlePlace.UNHANDLED;
            if (handlePlace == null) {
                ExceptionUtil.$$$reportNull$$$0(74);
            }
            return handlePlace;
        }
        PsiElement parent2 = element.getParent();
        if (parent2 == null || parent2 == topElement) {
            HandlePlace handlePlace = HandlePlace.UNHANDLED;
            if (handlePlace == null) {
                ExceptionUtil.$$$reportNull$$$0(75);
            }
            return handlePlace;
        }
        for (CustomExceptionHandler customExceptionHandler : CustomExceptionHandler.KEY.getExtensionList()) {
            if (!customExceptionHandler.isHandled(element, exceptionType, topElement)) continue;
            HandlePlace handlePlace = HandlePlace.UNKNOWN;
            if (handlePlace == null) {
                ExceptionUtil.$$$reportNull$$$0(76);
            }
            return handlePlace;
        }
        if (parent2 instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)parent2;
            HandlePlace handlePlace = HandlePlace.fromBoolean(ExceptionUtil.isHandledByMethodThrowsClause(method, exceptionType));
            if (handlePlace == null) {
                ExceptionUtil.$$$reportNull$$$0(77);
            }
            return handlePlace;
        }
        if (parent2 instanceof PsiClass) {
            if (!(parent2 instanceof PsiAnonymousClass)) {
                HandlePlace handlePlace = HandlePlace.UNHANDLED;
                if (handlePlace == null) {
                    ExceptionUtil.$$$reportNull$$$0(78);
                }
                return handlePlace;
            }
            return ExceptionUtil.getHandlePlace(parent2, exceptionType, topElement);
        }
        if (parent2 instanceof PsiLambdaExpression || parent2 instanceof PsiMethodReferenceExpression && element == ((PsiMethodReferenceExpression)parent2).getReferenceNameElement()) {
            PsiType interfaceType = ((PsiFunctionalExpression)parent2).getFunctionalInterfaceType();
            HandlePlace handlePlace = HandlePlace.fromBoolean(ExceptionUtil.isDeclaredBySAMMethod(exceptionType, interfaceType));
            if (handlePlace == null) {
                ExceptionUtil.$$$reportNull$$$0(79);
            }
            return handlePlace;
        }
        if (parent2 instanceof PsiClassInitializer) {
            if (((PsiClassInitializer)parent2).hasModifierProperty("static")) {
                HandlePlace handlePlace = HandlePlace.UNHANDLED;
                if (handlePlace == null) {
                    ExceptionUtil.$$$reportNull$$$0(80);
                }
                return handlePlace;
            }
            if (!(parent2.getParent() instanceof PsiAnonymousClass)) {
                aClass = ((PsiClassInitializer)parent2).getContainingClass();
                HandlePlace handlePlace = HandlePlace.fromBoolean(ExceptionUtil.areAllConstructorsThrow(aClass, exceptionType));
                if (handlePlace == null) {
                    ExceptionUtil.$$$reportNull$$$0(81);
                }
                return handlePlace;
            }
        } else if (parent2 instanceof PsiTryStatement) {
            HandlePlace handlePlace;
            HandlePlace handlePlace2;
            PsiTryStatement tryStatement = (PsiTryStatement)parent2;
            if (tryStatement.getTryBlock() == element && (handlePlace2 = ExceptionUtil.getCaughtPlace(tryStatement, exceptionType)) != HandlePlace.UNHANDLED) {
                HandlePlace handlePlace3 = handlePlace2;
                if (handlePlace3 == null) {
                    ExceptionUtil.$$$reportNull$$$0(82);
                }
                return handlePlace3;
            }
            if (tryStatement.getResourceList() == element && (handlePlace = ExceptionUtil.getCaughtPlace(tryStatement, exceptionType)) != HandlePlace.UNHANDLED) {
                HandlePlace handlePlace4 = handlePlace;
                if (handlePlace4 == null) {
                    ExceptionUtil.$$$reportNull$$$0(83);
                }
                return handlePlace4;
            }
            PsiCodeBlock psiCodeBlock = tryStatement.getFinallyBlock();
            if (element instanceof PsiCatchSection && psiCodeBlock != null && ExceptionUtil.blockCompletesAbruptly(psiCodeBlock)) {
                HandlePlace handlePlace5 = HandlePlace.UNKNOWN;
                if (handlePlace5 == null) {
                    ExceptionUtil.$$$reportNull$$$0(84);
                }
                return handlePlace5;
            }
        } else {
            if (parent2 instanceof JavaCodeFragment) {
                JavaCodeFragment codeFragment = (JavaCodeFragment)parent2;
                JavaCodeFragment.ExceptionHandler exceptionHandler = codeFragment.getExceptionHandler();
                HandlePlace handlePlace = HandlePlace.fromBoolean(exceptionHandler != null && exceptionHandler.isHandledException(exceptionType));
                if (handlePlace == null) {
                    ExceptionUtil.$$$reportNull$$$0(85);
                }
                return handlePlace;
            }
            if (PsiImplUtil.isInServerPage(parent2) && parent2 instanceof PsiFile) {
                HandlePlace handlePlace = HandlePlace.UNKNOWN;
                if (handlePlace == null) {
                    ExceptionUtil.$$$reportNull$$$0(86);
                }
                return handlePlace;
            }
            if (parent2 instanceof PsiFile) {
                HandlePlace handlePlace = HandlePlace.fromBoolean(false);
                if (handlePlace == null) {
                    ExceptionUtil.$$$reportNull$$$0(87);
                }
                return handlePlace;
            }
            if (parent2 instanceof PsiField && ((PsiField)parent2).getInitializer() == element && (aClass = ((PsiField)parent2).getContainingClass()) != null && !(aClass instanceof PsiAnonymousClass) && !((PsiField)parent2).hasModifierProperty("static")) {
                HandlePlace handlePlace = HandlePlace.fromBoolean(ExceptionUtil.areAllConstructorsThrow(aClass, exceptionType));
                if (handlePlace == null) {
                    ExceptionUtil.$$$reportNull$$$0(88);
                }
                return handlePlace;
            }
        }
        return ExceptionUtil.getHandlePlace(parent2, exceptionType, topElement);
    }

    private static boolean isDeclaredBySAMMethod(@NotNull PsiClassType exceptionType, @Nullable PsiType interfaceType) {
        PsiClassType.ClassResolveResult resolveResult;
        PsiMethod interfaceMethod;
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(89);
        }
        if (interfaceType != null && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult = PsiUtil.resolveGenericsClassInType(interfaceType))) != null) {
            return ExceptionUtil.isHandledByMethodThrowsClause(interfaceMethod, exceptionType, LambdaUtil.getSubstitutor(interfaceMethod, resolveResult));
        }
        return true;
    }

    private static boolean areAllConstructorsThrow(@Nullable PsiClass aClass, @NotNull PsiClassType exceptionType) {
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(90);
        }
        if (aClass == null) {
            return false;
        }
        PsiMethod[] constructors2 = aClass.getConstructors();
        boolean thrown = constructors2.length != 0;
        for (PsiMethod constructor : constructors2) {
            if (ExceptionUtil.isHandledByMethodThrowsClause(constructor, exceptionType)) continue;
            thrown = false;
            break;
        }
        return thrown;
    }

    @NotNull
    private static HandlePlace getCaughtPlace(@NotNull PsiTryStatement tryStatement, @NotNull PsiClassType exceptionType) {
        PsiParameter[] catchBlockParameters;
        PsiCodeBlock finallyBlock;
        if (tryStatement == null) {
            ExceptionUtil.$$$reportNull$$$0(91);
        }
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(92);
        }
        if ((finallyBlock = tryStatement.getFinallyBlock()) != null && ExceptionUtil.blockCompletesAbruptly(finallyBlock)) {
            HandlePlace handlePlace = HandlePlace.UNKNOWN;
            if (handlePlace == null) {
                ExceptionUtil.$$$reportNull$$$0(93);
            }
            return handlePlace;
        }
        for (PsiParameter parameter : catchBlockParameters = tryStatement.getCatchBlockParameters()) {
            PsiType paramType = parameter.getType();
            if (!paramType.isAssignableFrom(exceptionType)) continue;
            return new HandlePlace.TryCatch(tryStatement, parameter);
        }
        HandlePlace handlePlace = HandlePlace.UNHANDLED;
        if (handlePlace == null) {
            ExceptionUtil.$$$reportNull$$$0(94);
        }
        return handlePlace;
    }

    private static boolean blockCompletesAbruptly(@NotNull PsiCodeBlock finallyBlock) {
        if (finallyBlock == null) {
            ExceptionUtil.$$$reportNull$$$0(95);
        }
        try {
            ControlFlow flow = ControlFlowFactory.getInstance(finallyBlock.getProject()).getControlFlow(finallyBlock, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
            int completionReasons = ControlFlowUtil.getCompletionReasons(flow, 0, flow.getSize());
            if (!BitUtil.isSet(completionReasons, 1)) {
                return true;
            }
        }
        catch (AnalysisCanceledException e2) {
            return true;
        }
        return false;
    }

    private static boolean isHandledByMethodThrowsClause(@NotNull PsiMethod method, @NotNull PsiClassType exceptionType) {
        if (method == null) {
            ExceptionUtil.$$$reportNull$$$0(96);
        }
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(97);
        }
        return ExceptionUtil.isHandledByMethodThrowsClause(method, exceptionType, PsiSubstitutor.EMPTY);
    }

    private static boolean isHandledByMethodThrowsClause(@NotNull PsiMethod method, @NotNull PsiClassType exceptionType, PsiSubstitutor substitutor2) {
        if (method == null) {
            ExceptionUtil.$$$reportNull$$$0(98);
        }
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(99);
        }
        PsiClassType[] referencedTypes = method.getThrowsList().getReferencedTypes();
        return ExceptionUtil.isHandledBy(exceptionType, referencedTypes, substitutor2);
    }

    public static boolean isHandledBy(@NotNull PsiClassType exceptionType, PsiClassType @NotNull [] referencedTypes, PsiSubstitutor substitutor2) {
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(102);
        }
        if (referencedTypes == null) {
            ExceptionUtil.$$$reportNull$$$0(103);
        }
        for (PsiClassType classType : referencedTypes) {
            PsiType psiType = substitutor2.substitute(classType);
            if (psiType == null || !psiType.isAssignableFrom(exceptionType)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 14: 
            case 15: 
            case 21: 
            case 24: 
            case 28: 
            case 31: 
            case 33: 
            case 34: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 50: 
            case 52: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 63: 
            case 64: 
            case 65: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 93: 
            case 94: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 14: 
            case 15: 
            case 21: 
            case 24: 
            case 28: 
            case 31: 
            case 33: 
            case 34: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 50: 
            case 52: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 63: 
            case 64: 
            case 65: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 93: 
            case 94: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 14: 
            case 15: 
            case 21: 
            case 24: 
            case 28: 
            case 31: 
            case 33: 
            case 34: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 50: 
            case 52: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 63: 
            case 64: 
            case 65: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 93: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/codeInsight/ExceptionUtil";
                break;
            }
            case 5: 
            case 17: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 7: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tryStatement";
                break;
            }
            case 11: 
            case 46: 
            case 61: 
            case 66: 
            case 96: 
            case 98: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 12: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skippedCall";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callFilter";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodReferenceExpression";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructorBody";
                break;
            }
            case 36: 
            case 37: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skipCondition";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseMethod";
                break;
            }
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resource";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateExpression";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwStatement";
                break;
            }
            case 67: 
            case 69: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 71: 
            case 73: 
            case 89: 
            case 90: 
            case 92: 
            case 97: 
            case 99: 
            case 100: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionType";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwPlace";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finallyBlock";
                break;
            }
            case 101: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedTypes";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/codeInsight/ExceptionUtil";
                break;
            }
            case 1: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrownExceptions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrownCheckedExceptions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOutUncheckedExceptions";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTryExceptions";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getExceptionsByMethod";
                break;
            }
            case 21: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "collectUnhandledExceptions";
                break;
            }
            case 28: 
            case 31: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 57: 
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnhandledExceptions";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnUnhandledExceptions";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getCloserExceptions";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnhandledCloserExceptions";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnhandledProcessorExceptions";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreciseThrowTypes";
                break;
            }
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandlePlace";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaughtPlace";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getThrownExceptions";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 14: 
            case 15: 
            case 21: 
            case 24: 
            case 28: 
            case 31: 
            case 33: 
            case 34: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 50: 
            case 52: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 63: 
            case 64: 
            case 65: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 93: 
            case 94: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getThrownCheckedExceptions";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "filterOutUncheckedExceptions";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTryExceptions";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getExceptionsByMethod";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addExceptions";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addException";
                break;
            }
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "collectUnhandledExceptions";
                break;
            }
            case 27: 
            case 30: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 56: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getUnhandledExceptions";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "firstStatementIsConstructorCall";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getOwnUnhandledExceptions";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getMethodCallTargets";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateTargets";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getCloserExceptions";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getUnhandledCloserExceptions";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getUnhandledProcessorExceptions";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "isArrayClone";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "isUncheckedException";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "isUncheckedExceptionOrSuperclass";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "isGeneralExceptionType";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "isHandled";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getHandlePlace";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "isDeclaredBySAMMethod";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "areAllConstructorsThrow";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "getCaughtPlace";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "blockCompletesAbruptly";
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "isHandledByMethodThrowsClause";
                break;
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "isHandledBy";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "sortExceptionsByHierarchy";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "canDeclareThrownExceptions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 14: 
            case 15: 
            case 21: 
            case 24: 
            case 28: 
            case 31: 
            case 33: 
            case 34: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 50: 
            case 52: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 63: 
            case 64: 
            case 65: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 93: 
            case 94: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface HandlePlace {
        public static final HandlePlace UNHANDLED = new HandlePlace(){};
        public static final HandlePlace UNKNOWN = new HandlePlace(){};

        public static HandlePlace fromBoolean(boolean isHandled) {
            return isHandled ? UNKNOWN : UNHANDLED;
        }

        public static class TryCatch
        implements HandlePlace {
            private final PsiTryStatement myTryStatement;
            private final PsiParameter myParameter;

            public TryCatch(PsiTryStatement statement, PsiParameter parameter) {
                this.myTryStatement = statement;
                this.myParameter = parameter;
            }
        }
    }
}

