/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.moduleconverter;

import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.api.internal.artifacts.configurations.ConfigurationsProvider;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.AdhocRootComponentProvider;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.RootComponentProvider;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.immutable.ImmutableAttributesSchema;
import org.gradle.api.internal.attributes.immutable.ImmutableAttributesSchemaFactory;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveMetadata;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveState;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveStateFactory;
import org.gradle.internal.model.ModelContainer;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.jspecify.annotations.Nullable;

@ServiceScope(value={Scope.Project.class})
public class ProjectRootComponentProvider
implements RootComponentProvider {
    private final ProjectState owner;
    private final DependencyMetaDataProvider componentIdentity;
    private final AttributesSchemaInternal schema;
    private final ConfigurationsProvider configurationsProvider;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final LocalComponentGraphResolveStateFactory localResolveStateFactory;
    private final ImmutableAttributesSchemaFactory attributesSchemaFactory;
    private final AdhocRootComponentProvider adhocRootComponentProvider;
    private @Nullable LocalComponentGraphResolveState cachedValue;

    public ProjectRootComponentProvider(ProjectState owner, DependencyMetaDataProvider componentIdentity, AttributesSchemaInternal schema, ConfigurationsProvider configurationsProvider, ImmutableModuleIdentifierFactory moduleIdentifierFactory, LocalComponentGraphResolveStateFactory localResolveStateFactory, ImmutableAttributesSchemaFactory attributesSchemaFactory, AdhocRootComponentProvider adhocRootComponentProvider) {
        this.owner = owner;
        this.componentIdentity = componentIdentity;
        this.schema = schema;
        this.configurationsProvider = configurationsProvider;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.localResolveStateFactory = localResolveStateFactory;
        this.attributesSchemaFactory = attributesSchemaFactory;
        this.adhocRootComponentProvider = adhocRootComponentProvider;
    }

    @Override
    public LocalComponentGraphResolveState getRootComponent(boolean detached) {
        if (detached) {
            return this.adhocRootComponentProvider.getRootComponent(true);
        }
        if (this.cachedValue == null) {
            this.cachedValue = this.createProjectRootComponent();
        }
        return this.cachedValue;
    }

    private LocalComponentGraphResolveState createProjectRootComponent() {
        Module module = this.componentIdentity.getModule();
        ModuleVersionIdentifier moduleVersionId = this.moduleIdentifierFactory.moduleWithVersion(module.getGroup(), module.getName(), module.getVersion());
        ProjectComponentIdentifier componentIdentifier = this.owner.getComponentIdentifier();
        String status = module.getStatus();
        ImmutableAttributesSchema immutableSchema = this.attributesSchemaFactory.create(this.schema);
        LocalComponentGraphResolveMetadata metadata = new LocalComponentGraphResolveMetadata(moduleVersionId, (ComponentIdentifier)componentIdentifier, status, immutableSchema);
        return this.localResolveStateFactory.stateFor((ModelContainer<?>)this.owner, metadata, this.configurationsProvider);
    }
}

