/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.correlate;

import java.util.ArrayList;
import java.util.TimeZone;
import javax.swing.table.AbstractTableModel;
import tim.prune.I18nManager;
import tim.prune.correlate.MediaSelectionTableRow;
import tim.prune.data.MediaObject;

public class MediaSelectionTableModel
extends AbstractTableModel {
    private final String _firstColumnHeading;
    private final String _lastColumnHeading;
    private final ArrayList<MediaSelectionTableRow> _list = new ArrayList();
    private final TimeZone _timezone;

    public MediaSelectionTableModel(String string, String string2, TimeZone timeZone) {
        this._firstColumnHeading = I18nManager.getText(string);
        this._lastColumnHeading = I18nManager.getText(string2);
        this._timezone = timeZone;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            return this._firstColumnHeading;
        }
        if (n == 1) {
            return I18nManager.getText("fieldname.timestamp");
        }
        if (n == 2) {
            return I18nManager.getText("dialog.correlate.select.timediff");
        }
        return this._lastColumnHeading;
    }

    @Override
    public int getRowCount() {
        return this._list.size();
    }

    public MediaSelectionTableRow getRow(int n) {
        return this._list.get(n);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        MediaSelectionTableRow mediaSelectionTableRow = this._list.get(n);
        if (n2 == 0) {
            return mediaSelectionTableRow.getMedia().getName();
        }
        if (n2 == 1) {
            return mediaSelectionTableRow.getMedia().hasTimestamp() ? mediaSelectionTableRow.getMedia().getTimestamp().getText(this._timezone) : "";
        }
        if (n2 == 2) {
            return mediaSelectionTableRow.getTimeDiff().getDescription();
        }
        return mediaSelectionTableRow.getTimeDiff().getIsPositive() ? I18nManager.getText("dialog.about.yes") : I18nManager.getText("dialog.about.no");
    }

    public void reset() {
        this._list.clear();
    }

    public void addMedia(MediaObject mediaObject, long l) {
        this._list.add(new MediaSelectionTableRow(mediaObject, l));
    }
}

