# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ArtifactRegistry
      module V1
        # The Artifact Registry VPC SC config that apply to a Project.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of the project's VPC SC Config.
        #
        #     Always of the form:
        #     projects/\\{projectID}/locations/\\{location}/vpcscConfig
        #
        #     In update request: never set
        #     In response: always set
        # @!attribute [rw] vpcsc_policy
        #   @return [::Google::Cloud::ArtifactRegistry::V1::VPCSCConfig::VPCSCPolicy]
        #     The project per location VPC SC policy that defines the VPC SC behavior for
        #     the Remote Repository (Allow/Deny).
        class VPCSCConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # VPCSCPolicy is the VPC SC policy for project and location.
          module VPCSCPolicy
            # VPCSC_POLICY_UNSPECIFIED - the VPS SC policy is not defined.
            # When VPS SC policy is not defined - the Service will use the default
            # behavior (VPCSC_DENY).
            VPCSC_POLICY_UNSPECIFIED = 0

            # VPCSC_DENY - repository will block the requests to the Upstreams for the
            # Remote Repositories if the resource is in the perimeter.
            DENY = 1

            # VPCSC_ALLOW - repository will allow the requests to the Upstreams for the
            # Remote Repositories if the resource is in the perimeter.
            ALLOW = 2
          end
        end

        # Gets the VPC SC config for a project.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the VPCSCConfig resource.
        class GetVPCSCConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Sets the VPCSC config of the project.
        # @!attribute [rw] vpcsc_config
        #   @return [::Google::Cloud::ArtifactRegistry::V1::VPCSCConfig]
        #     The project config.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Field mask to support partial updates.
        class UpdateVPCSCConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
