# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: operations.proto for package 'gitaly'

require 'grpc'
require 'operations_pb'

module Gitaly
  module OperationService
    # OperationService provides an interface for performing mutating git
    # operations on a repository on behalf of a user. The user's operation is
    # treated as untrusted. Any reference update is thus checked against GitLab's
    # '/allowed' endpoint.
    class Service

      include ::GRPC::GenericService

      self.marshal_class_method = :encode
      self.unmarshal_class_method = :decode
      self.service_name = 'gitaly.OperationService'

      # UserCreateBranch creates a single branch in the context of a specific user. It executes
      # hooks and contacts Rails to verify that the user is allowed to create the branch. The
      # following known error conditions may happen:
      #
      # - `FailedPrecondition` if the Git revision provided in start_point can't be found or updated.
      # - `InvalidArgument` if the commit ID resolved from the start_point can't be parsed.
      # - `PermissionDenied` with an embedded `UserCreateBranchError` if any custom hooks return a
      #    non-zero exit code.
      rpc :UserCreateBranch, ::Gitaly::UserCreateBranchRequest, ::Gitaly::UserCreateBranchResponse
      # UserUpdateBranch updates a branch to point to a new revision. It executes hooks and
      # contacts Rails to verify that the user is allowed to update the branch. The following
      # known error conditions may happen:
      #
      # - `InvalidArgument` if any of the request fields can't be validated.
      # - `Internal` if the newrev or oldrev are invalid in the context of the repository.
      # - `UserUpdateBranchResponse` with the `PreReceiveError` field set, if any custom hooks
      #   return a non-zero exit code.
      rpc :UserUpdateBranch, ::Gitaly::UserUpdateBranchRequest, ::Gitaly::UserUpdateBranchResponse
      # UserDeleteBranch force-deletes a single branch in the context of a specific user. It executes
      # hooks and contacts Rails to verify that the user is indeed allowed to delete that branch. The
      # following known error conditions may happen:
      #
      # - Returns `InvalidArgument` in case either the branch name or user are not set.
      # - Returns `FailedPrecondition` in case the branch does not exist.
      # - Returns `OK` with a `PreReceiveError` in case custom hooks refused the update. If the
      #   `gitaly_user_delete_branch_structured_errors` feature flag is enabled this error case will
      #   instead return `PermissionDenied` with either a `CustomHook` or AccessCheck` structured
      #   error.
      # - Returns `FailedPrecondition` in case updating the reference fails because
      #   of a concurrent write to the same reference. If the
      #   `gitaly_user_delete_branch_structured_errors` feature flag is set this error case will
      #   instead return `FailedPrecondition` with a `ReferenceUpdate` structured error.
      rpc :UserDeleteBranch, ::Gitaly::UserDeleteBranchRequest, ::Gitaly::UserDeleteBranchResponse
      # UserCreateTag creates a new tag. This RPC knows to create both lightweight and annotated tags
      # depending on whether a message is set.
      rpc :UserCreateTag, ::Gitaly::UserCreateTagRequest, ::Gitaly::UserCreateTagResponse
      # UserDeleteTag deletes an existing tag. It executes hooks and contacts Rails to verify that
      # the user is allowed to delete the tag. The following known error conditions may happen:
      #
      # - `InvalidArgument` if the repository, tag_name, user, or expected_old_oid (if provided)
      #   are invalid.
      # - `FailedPrecondition` if the tag_name can't be found, or the ref couldn't be deleted due
      #   to a concurrent write to the same ref.
      # - `Internal` if the tag_name can't be resolved or an unknown error occurs.
      rpc :UserDeleteTag, ::Gitaly::UserDeleteTagRequest, ::Gitaly::UserDeleteTagResponse
      # UserMergeToRef creates a merge commit and updates target_ref to point to that
      # new commit. The first parent of the merge commit (the main line) is taken
      # from first_parent_ref. The second parent is specified by its commit ID in source_sha.
      # If target_ref already exists it will be overwritten.
      rpc :UserMergeToRef, ::Gitaly::UserMergeToRefRequest, ::Gitaly::UserMergeToRefResponse
      # UserRebaseToRef rebases source_sha on top of first_parent_ref and updates
      # target_ref to point to that new commit. If target_ref already exists, then
      # it will be overwritten. This operation is intended to be used on internal
      # refs (e.g. refs/merge-requests/*) and does not call hooks.
      rpc :UserRebaseToRef, ::Gitaly::UserRebaseToRefRequest, ::Gitaly::UserRebaseToRefResponse
      # UserMergeBranch tries to merge the given commit into the target branch.
      # The merge commit is created with the given user as author/committer and
      # the given message.
      #
      # This is a two-stage RPC that requires confirmation to make user-visible
      # changes to the repository:
      # - The first request contains details about the requested merge, which
      #   will result in a response with the created merge commit ID.
      # - The second request should set `apply = true` to apply the merge.
      #
      # After the second request, it executes hooks and contacts Rails to verify
      # that the user is allowed to update the branch. The following known error
      # conditions may happen:
      #
      # - `InvalidArgument` if request fields can't be validated or resolved.
      # - `NotFound` if the branch can't be found.
      # - `FailedPrecondition` if there are merge conflicts, if the merge is
      #   aborted by setting `apply = false` in the second request, or if the
      #   merge fails due to a concurrent write to the same ref.
      # - `PermissionDenied` if the user doesn't have permissions to merge a branch.
      rpc :UserMergeBranch, stream(::Gitaly::UserMergeBranchRequest), stream(::Gitaly::UserMergeBranchResponse)
      # UserFFBranch tries to perform a fast-forward merge of a given commit into
      # the given branch. If the merge is not a fast-forward merge, the request
      # will fail. The RPC will return an empty response in case updating the
      # reference fails e.g. because of a race.
      rpc :UserFFBranch, ::Gitaly::UserFFBranchRequest, ::Gitaly::UserFFBranchResponse
      # UserCherryPick tries to perform a cherry-pick of a given commit onto a
      # branch.
      rpc :UserCherryPick, ::Gitaly::UserCherryPickRequest, ::Gitaly::UserCherryPickResponse
      # UserCommitFiles builds a commit from a stream of actions and updates the target branch to point to it.
      # userCommitFilesRequest with a UserCommitFilesRequestHeader must be sent as the first message of the stream.
      # Following that, a variable number of actions can be sent to build a new commit. Each action consists of
      # a header followed by content if used by the action.
      rpc :UserCommitFiles, stream(::Gitaly::UserCommitFilesRequest), ::Gitaly::UserCommitFilesResponse
      # UserRebaseConfirmable rebases the given remote branch onto a target
      # branch. The remote branch may be part of another repository.
      #
      # This RPC requires confirmation to make any user-visible changes to the
      # repository. The first request sent shall contains details about the
      # requested rebase, which will result in a response with the created rebase
      # commit ID. Only if a second message with `apply = true` is sent will the
      # rebase be applied.
      rpc :UserRebaseConfirmable, stream(::Gitaly::UserRebaseConfirmableRequest), stream(::Gitaly::UserRebaseConfirmableResponse)
      # UserRevert tries to perform a revert of a given commit onto a branch.
      rpc :UserRevert, ::Gitaly::UserRevertRequest, ::Gitaly::UserRevertResponse
      # UserSquash squashes a range of commits into a single commit. If
      # successful, it returns the object ID of the newly created squash commit.
      # On error, it returns a gRPC error. Some specific errors will have an
      # embedded UserSquashError such that clients can deduce what exactly has
      # failed.
      rpc :UserSquash, ::Gitaly::UserSquashRequest, ::Gitaly::UserSquashResponse
      # UserApplyPatch applies patches to a given branch.
      rpc :UserApplyPatch, stream(::Gitaly::UserApplyPatchRequest), ::Gitaly::UserApplyPatchResponse
      # UserUpdateSubmodule updates a submodule to point to a new commit.
      rpc :UserUpdateSubmodule, ::Gitaly::UserUpdateSubmoduleRequest, ::Gitaly::UserUpdateSubmoduleResponse
    end

    Stub = Service.rpc_stub_class
  end
end
