---
stage: Solutions Architecture
group: Solutions Architecture
info: This page is owned by the Solutions Architecture team.
description: Overview of GitLab AI solution components and use cases, including Duo Workflow.
title: GitLab AI Solution Components
---

This documentation section covers a variety of Solution components developed and provided by GitLab.
To download and run these solution components, request your account team for invitation code.

The use of any Solution component is subject to the [GitLab Subscription Agreement](https://handbook.gitlab.com/handbook/legal/subscription-agreement/) (the "Agreement") and constitutes Free Software as defined within the Agreement.

## GitLab Duo Workflow

GitLab Duo Workflow helps you complete development tasks. The GitLab codebase, issues, merge requests and pipelines can be the context where the agentic workflow can be carried out from the prompt using the VS Code integrated development environment (IDE).

For detailed information about GitLab Duo Workflow, review [the document here](../../../user/duo_agent_platform/_index.md).

## Duo Workflow Solution

The Duo Workflow Solution provides prompt and context library for different software development use cases. Each solution use case with the prompt and context library support the desired automous workflow to automate the development tasks, including tasks ranged from coding changes, problem fixing and code review based on the defined workflow plan.

[Agentic Workflow: Apply Coding Style Guide](duo_workflow_codestyle.md)
