# frozen_string_literal: true

class AddVulnerabilityOccurrenceIdentifiersProjectIdIndex < Gitlab::Database::Migration[2.2]
  disable_ddl_transaction!
  milestone '17.11'

  INDEX_NAME = 'index_vulnerability_occurrence_identifiers_on_project_id'

  def up
    add_concurrent_index :vulnerability_occurrence_identifiers, :project_id, name: INDEX_NAME
  end

  def down
    remove_concurrent_index_by_name :vulnerability_occurrence_identifiers, INDEX_NAME
  end
end
