# frozen_string_literal: true

class AddIndexToVulnerabilityIdentifiersOnProjectIdAndName < Gitlab::Database::Migration[2.2]
  disable_ddl_transaction!

  milestone '17.7'

  INDEX_NAME = 'index_vulnerability_identifiers_on_project_id_and_name'

  def up
    add_concurrent_index :vulnerability_identifiers, [:project_id, :name], name: INDEX_NAME
  end

  def down
    remove_concurrent_index_by_name :vulnerability_identifiers, name: INDEX_NAME
  end
end
