/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.ui.components.JColorButton;
import org.gephi.ui.utils.UIUtils;
import org.gephi.visualization.VizController;
import org.gephi.visualization.component.VizBarController;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ActionsToolbar
extends JToolBar {
    private Color color = new Color(0.6f, 0.6f, 0.6f);
    private float size = 10.0f;

    public ActionsToolbar() {
        this.initDesign();
        this.initContent();
    }

    private void initContent() {
        JButton centerOnGraphButton = new JButton();
        centerOnGraphButton.setToolTipText(NbBundle.getMessage(VizBarController.class, (String)"ActionsToolbar.centerOnGraph"));
        centerOnGraphButton.setIcon(ImageUtilities.loadImageIcon((String)"VisualizationImpl/centerOnGraph.png", (boolean)false));
        centerOnGraphButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VizController.getInstance().getGraphIO().centerOnGraph();
            }
        });
        this.add(centerOnGraphButton);
        final JColorButton resetColorButton = new JColorButton(this.color, true, false);
        resetColorButton.setToolTipText(NbBundle.getMessage(ActionsToolbar.class, (String)"ActionsToolbar.resetColors"));
        resetColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionsToolbar.this.color = resetColorButton.getColor();
                GraphController gc = (GraphController)Lookup.getDefault().lookup(GraphController.class);
                GraphModel gm = gc.getGraphModel();
                Graph graph = gm.getGraphVisible();
                for (Node n : graph.getNodes()) {
                    n.setR((float)ActionsToolbar.this.color.getRed() / 255.0f);
                    n.setG((float)ActionsToolbar.this.color.getGreen() / 255.0f);
                    n.setB((float)ActionsToolbar.this.color.getBlue() / 255.0f);
                    n.setAlpha(1.0f);
                }
                for (Edge e : graph.getEdges()) {
                    e.setR((float)ActionsToolbar.this.color.getRed() / 255.0f);
                    e.setG((float)ActionsToolbar.this.color.getGreen() / 255.0f);
                    e.setB((float)ActionsToolbar.this.color.getBlue() / 255.0f);
                    e.setAlpha(0.0f);
                }
            }
        });
        this.add((Component)resetColorButton);
        JButton resetLabelColorButton = new JButton();
        resetLabelColorButton.setIcon(ImageUtilities.loadImageIcon((String)"VisualizationImpl/resetLabelColor.png", (boolean)false));
        resetLabelColorButton.setToolTipText(NbBundle.getMessage(ActionsToolbar.class, (String)"ActionsToolbar.resetLabelColors"));
        resetLabelColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphController gc = (GraphController)Lookup.getDefault().lookup(GraphController.class);
                GraphModel gm = gc.getGraphModel();
                Graph graph = gm.getGraphVisible();
                for (Node node : graph.getNodes().toArray()) {
                    node.getTextProperties().setColor(Color.BLACK);
                    node.getTextProperties().setAlpha(0.0f);
                }
                for (Node node : graph.getEdges().toArray()) {
                    node.getTextProperties().setColor(Color.BLACK);
                    node.getTextProperties().setAlpha(0.0f);
                }
            }
        });
        this.add(resetLabelColorButton);
        JButton resetLabelVisibleButton = new JButton();
        resetLabelVisibleButton.setIcon(ImageUtilities.loadImageIcon((String)"VisualizationImpl/resetLabelVisible.png", (boolean)false));
        resetLabelVisibleButton.setToolTipText(NbBundle.getMessage(ActionsToolbar.class, (String)"ActionsToolbar.resetLabelVisible"));
        resetLabelVisibleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphController gc = (GraphController)Lookup.getDefault().lookup(GraphController.class);
                GraphModel gm = gc.getGraphModel();
                Graph graph = gm.getGraphVisible();
                for (Node n : graph.getNodes()) {
                    n.getTextProperties().setVisible(true);
                }
                for (Edge e : graph.getEdges()) {
                    e.getTextProperties().setVisible(true);
                }
            }
        });
        this.add(resetLabelVisibleButton);
    }

    private void initDesign() {
        this.setFloatable(false);
        this.setOrientation(1);
        this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.setBorder(BorderFactory.createEmptyBorder(0, 2, 15, 2));
        this.setOpaque(true);
    }

    @Override
    public void setEnabled(final boolean enabled) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Component c : ActionsToolbar.this.getComponents()) {
                    c.setEnabled(enabled);
                }
            }
        });
    }

    @Override
    public Component add(Component comp) {
        if (comp instanceof JButton) {
            UIUtils.fixButtonUI((AbstractButton)((JButton)comp));
        }
        return super.add(comp);
    }
}

