/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.search.impl;

import org.gephi.desktop.search.api.SearchResult;
import org.gephi.desktop.search.spi.SearchProvider;

public class SearchResultImpl<T>
implements SearchResult<T>,
Comparable<SearchResultImpl<T>> {
    private final T result;
    private final SearchProvider<T> provider;
    private final int position;
    private final String htmlDisplay;
    private final String matchLocation;

    public SearchResultImpl(SearchProvider<T> provider, int position, T result, String htmlDisplay, String matchLocation) {
        this.provider = provider;
        this.position = position;
        this.result = result;
        this.htmlDisplay = htmlDisplay;
        this.matchLocation = matchLocation;
    }

    @Override
    public T getResult() {
        return this.result;
    }

    protected SearchProvider<T> getProvider() {
        return this.provider;
    }

    @Override
    public String getHtmlDisplay() {
        return this.htmlDisplay;
    }

    @Override
    public String getMatchLocation() {
        return this.matchLocation;
    }

    public int getPosition() {
        return this.position;
    }

    public String toString() {
        return "<html>" + this.getHtmlDisplay() + " <font color='#aaaaaa'>" + this.getMatchLocation() + "</font></html>";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchResultImpl that = (SearchResultImpl)o;
        return this.result.equals(that.result);
    }

    public int hashCode() {
        return this.result.hashCode();
    }

    @Override
    public int compareTo(SearchResultImpl<T> o) {
        return Integer.compare(this.position, o.position);
    }
}

