/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.nsac.NamespacePrefixMap;
import io.sf.carte.doc.style.css.nsac.Selector;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.parser.AbstractSACList;
import io.sf.carte.doc.style.css.parser.AbstractSelector;
import io.sf.carte.doc.style.css.parser.MutableBoolean;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import org.w3c.dom.DOMException;

class SelectorListImpl
extends AbstractSACList<Selector>
implements SelectorList {
    private static final long serialVersionUID = 1L;

    SelectorListImpl() {
    }

    SelectorListImpl(Collection<? extends Selector> c) {
        super(c);
    }

    SelectorListImpl(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public boolean contains(Selector sel) {
        return super.contains(sel);
    }

    @Override
    public boolean containsAll(SelectorList list) {
        if (list instanceof Collection) {
            Collection c = (Collection)((Object)list);
            return super.containsAll(c);
        }
        for (Selector sele : list) {
            if (this.contains(sele)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Selector replace(int index, Selector selector) throws DOMException {
        if (index < 0 || index >= this.getLength()) {
            throw new DOMException(1, "Wrong index: " + index);
        }
        if (selector == null) {
            throw new NullPointerException("Null selector");
        }
        return this.set(index, selector);
    }

    public void setNamespacePrefixMap(NamespacePrefixMap map) {
        Selector sel;
        Iterator iterator = this.iterator();
        while (iterator.hasNext() && !((AbstractSelector)(sel = (Selector)iterator.next())).setNamespacePrefixMap(map)) {
        }
    }

    @Override
    public SelectorListImpl replaceNested(SelectorList base) {
        SelectorListImpl clon = (SelectorListImpl)this.clone();
        ListIterator<Selector> it = clon.listIterator();
        while (it.hasNext()) {
            AbstractSelector sel = (AbstractSelector)it.next();
            MutableBoolean replaced = new MutableBoolean();
            Selector repl = sel.replace(base, replaced);
            if (!replaced.isTrue()) {
                repl = ((AbstractSelector)repl).descendant(base);
            }
            it.set(repl);
        }
        return clon;
    }

    SelectorListImpl replaceNestedArgument(SelectorList base, MutableBoolean replaced) {
        SelectorListImpl clon = (SelectorListImpl)this.clone();
        ListIterator<Selector> it = clon.listIterator();
        while (it.hasNext()) {
            AbstractSelector sel = (AbstractSelector)it.next();
            Selector repl = sel.replace(base, replaced);
            it.set(repl);
        }
        return clon;
    }
}

