/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.BooleanArrayList;
import com.google.protobuf.ByteString;
import com.google.protobuf.CheckReturnValue;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.DoubleArrayList;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.FieldSet;
import com.google.protobuf.FloatArrayList;
import com.google.protobuf.GeneratedMessageLite;
import com.google.protobuf.IntArrayList;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LongArrayList;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageSchema;
import com.google.protobuf.Protobuf;
import com.google.protobuf.Schema;
import com.google.protobuf.SchemaUtil;
import com.google.protobuf.UnknownFieldSchema;
import com.google.protobuf.UnknownFieldSetLite;
import com.google.protobuf.Utf8;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.util.List;

@CheckReturnValue
final class ArrayDecoders {
    private ArrayDecoders() {
    }

    static int decodeVarint32(byte[] data2, int position, Registers registers) {
        int value;
        if ((value = data2[position++]) >= 0) {
            registers.int1 = value;
            return position;
        }
        return ArrayDecoders.decodeVarint32(value, data2, position, registers);
    }

    static int decodeVarint32(int firstByte, byte[] data2, int position, Registers registers) {
        byte b5;
        byte b4;
        byte b3;
        byte b2;
        int value = firstByte & 0x7F;
        if ((b2 = data2[position++]) >= 0) {
            registers.int1 = value | b2 << 7;
            return position;
        }
        value |= (b2 & 0x7F) << 7;
        if ((b3 = data2[position++]) >= 0) {
            registers.int1 = value | b3 << 14;
            return position;
        }
        value |= (b3 & 0x7F) << 14;
        if ((b4 = data2[position++]) >= 0) {
            registers.int1 = value | b4 << 21;
            return position;
        }
        value |= (b4 & 0x7F) << 21;
        if ((b5 = data2[position++]) >= 0) {
            registers.int1 = value | b5 << 28;
            return position;
        }
        value |= (b5 & 0x7F) << 28;
        while (data2[position++] < 0) {
        }
        registers.int1 = value;
        return position;
    }

    static int decodeVarint64(byte[] data2, int position, Registers registers) {
        long value;
        if ((value = (long)data2[position++]) >= 0L) {
            registers.long1 = value;
            return position;
        }
        return ArrayDecoders.decodeVarint64(value, data2, position, registers);
    }

    static int decodeVarint64(long firstByte, byte[] data2, int position, Registers registers) {
        long value = firstByte & 0x7FL;
        byte next = data2[position++];
        int shift = 7;
        value |= (long)(next & 0x7F) << 7;
        while (next < 0) {
            next = data2[position++];
            value |= (long)(next & 0x7F) << (shift += 7);
        }
        registers.long1 = value;
        return position;
    }

    static int decodeFixed32(byte[] data2, int position) {
        return data2[position] & 0xFF | (data2[position + 1] & 0xFF) << 8 | (data2[position + 2] & 0xFF) << 16 | (data2[position + 3] & 0xFF) << 24;
    }

    static long decodeFixed64(byte[] data2, int position) {
        return (long)data2[position] & 0xFFL | ((long)data2[position + 1] & 0xFFL) << 8 | ((long)data2[position + 2] & 0xFFL) << 16 | ((long)data2[position + 3] & 0xFFL) << 24 | ((long)data2[position + 4] & 0xFFL) << 32 | ((long)data2[position + 5] & 0xFFL) << 40 | ((long)data2[position + 6] & 0xFFL) << 48 | ((long)data2[position + 7] & 0xFFL) << 56;
    }

    static double decodeDouble(byte[] data2, int position) {
        return Double.longBitsToDouble(ArrayDecoders.decodeFixed64(data2, position));
    }

    static float decodeFloat(byte[] data2, int position) {
        return Float.intBitsToFloat(ArrayDecoders.decodeFixed32(data2, position));
    }

    static int decodeString(byte[] data2, int position, Registers registers) throws InvalidProtocolBufferException {
        position = ArrayDecoders.decodeVarint32(data2, position, registers);
        int length = registers.int1;
        if (length < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (length == 0) {
            registers.object1 = "";
            return position;
        }
        registers.object1 = new String(data2, position, length, Internal.UTF_8);
        return position + length;
    }

    static int decodeStringRequireUtf8(byte[] data2, int position, Registers registers) throws InvalidProtocolBufferException {
        position = ArrayDecoders.decodeVarint32(data2, position, registers);
        int length = registers.int1;
        if (length < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (length == 0) {
            registers.object1 = "";
            return position;
        }
        registers.object1 = Utf8.decodeUtf8(data2, position, length);
        return position + length;
    }

    static int decodeBytes(byte[] data2, int position, Registers registers) throws InvalidProtocolBufferException {
        position = ArrayDecoders.decodeVarint32(data2, position, registers);
        int length = registers.int1;
        if (length < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (length > data2.length - position) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        if (length == 0) {
            registers.object1 = ByteString.EMPTY;
            return position;
        }
        registers.object1 = ByteString.copyFrom(data2, position, length);
        return position + length;
    }

    static int decodeMessageField(Schema schema, byte[] data2, int position, int limit, Registers registers) throws IOException {
        Object msg = schema.newInstance();
        int offset = ArrayDecoders.mergeMessageField(msg, schema, data2, position, limit, registers);
        schema.makeImmutable(msg);
        registers.object1 = msg;
        return offset;
    }

    static int decodeGroupField(Schema schema, byte[] data2, int position, int limit, int endGroup, Registers registers) throws IOException {
        Object msg = schema.newInstance();
        int offset = ArrayDecoders.mergeGroupField(msg, schema, data2, position, limit, endGroup, registers);
        schema.makeImmutable(msg);
        registers.object1 = msg;
        return offset;
    }

    static int mergeMessageField(Object msg, Schema schema, byte[] data2, int position, int limit, Registers registers) throws IOException {
        int length;
        if ((length = data2[position++]) < 0) {
            position = ArrayDecoders.decodeVarint32(length, data2, position, registers);
            length = registers.int1;
        }
        if (length < 0 || length > limit - position) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        schema.mergeFrom(msg, data2, position, position + length, registers);
        registers.object1 = msg;
        return position + length;
    }

    static int mergeGroupField(Object msg, Schema schema, byte[] data2, int position, int limit, int endGroup, Registers registers) throws IOException {
        MessageSchema messageSchema = (MessageSchema)schema;
        int endPosition = messageSchema.parseProto2Message(msg, data2, position, limit, endGroup, registers);
        registers.object1 = msg;
        return endPosition;
    }

    static int decodeVarint32List(int tag, byte[] data2, int position, int limit, Internal.ProtobufList<?> list2, Registers registers) {
        IntArrayList output = (IntArrayList)list2;
        position = ArrayDecoders.decodeVarint32(data2, position, registers);
        output.addInt(registers.int1);
        while (position < limit) {
            int nextPosition = ArrayDecoders.decodeVarint32(data2, position, registers);
            if (tag != registers.int1) break;
            position = ArrayDecoders.decodeVarint32(data2, nextPosition, registers);
            output.addInt(registers.int1);
        }
        return position;
    }

    static int decodeVarint64List(int tag, byte[] data2, int position, int limit, Internal.ProtobufList<?> list2, Registers registers) {
        LongArrayList output = (LongArrayList)list2;
        position = ArrayDecoders.decodeVarint64(data2, position, registers);
        output.addLong(registers.long1);
        while (position < limit) {
            int nextPosition = ArrayDecoders.decodeVarint32(data2, position, registers);
            if (tag != registers.int1) break;
            position = ArrayDecoders.decodeVarint64(data2, nextPosition, registers);
            output.addLong(registers.long1);
        }
        return position;
    }

    static int decodeFixed32List(int tag, byte[] data2, int position, int limit, Internal.ProtobufList<?> list2, Registers registers) {
        IntArrayList output = (IntArrayList)list2;
        output.addInt(ArrayDecoders.decodeFixed32(data2, position));
        position += 4;
        while (position < limit) {
            int nextPosition = ArrayDecoders.decodeVarint32(data2, position, registers);
            if (tag != registers.int1) break;
            output.addInt(ArrayDecoders.decodeFixed32(data2, nextPosition));
            position = nextPosition + 4;
        }
        return position;
    }

    static int decodeFixed64List(int tag, byte[] data2, int position, int limit, Internal.ProtobufList<?> list2, Registers registers) {
        LongArrayList output = (LongArrayList)list2;
        output.addLong(ArrayDecoders.decodeFixed64(data2, position));
        position += 8;
        while (position < limit) {
            int nextPosition = ArrayDecoders.decodeVarint32(data2, position, registers);
            if (tag != registers.int1) break;
            output.addLong(ArrayDecoders.decodeFixed64(data2, nextPosition));
            position = nextPosition + 8;
        }
        return position;
    }

    static int decodeFloatList(int tag, byte[] data2, int position, int limit, Internal.ProtobufList<?> list2, Registers registers) {
        FloatArrayList output = (FloatArrayList)list2;
        output.addFloat(ArrayDecoders.decodeFloat(data2, position));
        position += 4;
        while (position < limit) {
            int nextPosition = ArrayDecoders.decodeVarint32(data2, position, registers);
            if (tag != registers.int1) break;
            output.addFloat(ArrayDecoders.decodeFloat(data2, nextPosition));
            position = nextPosition + 4;
        }
        return position;
    }

    static int decodeDoubleList(int tag, byte[] data2, int position, int limit, Internal.ProtobufList<?> list2, Registers registers) {
        DoubleArrayList output = (DoubleArrayList)list2;
        output.addDouble(ArrayDecoders.decodeDouble(data2, position));
        position += 8;
        while (position < limit) {
            int nextPosition = ArrayDecoders.decodeVarint32(data2, position, registers);
            if (tag != registers.int1) break;
            output.addDouble(ArrayDecoders.decodeDouble(data2, nextPosition));
            position = nextPosition + 8;
        }
        return position;
    }

    static int decodeBoolList(int tag, byte[] data2, int position, int limit, Internal.ProtobufList<?> list2, Registers registers) {
        BooleanArrayList output = (BooleanArrayList)list2;
        position = ArrayDecoders.decodeVarint64(data2, position, registers);
        output.addBoolean(registers.long1 != 0L);
        while (position < limit) {
            int nextPosition = ArrayDecoders.decodeVarint32(data2, position, registers);
            if (tag != registers.int1) break;
            position = ArrayDecoders.decodeVarint64(data2, nextPosition, registers);
            output.addBoolean(registers.long1 != 0L);
        }
        return position;
    }

    static int decodeSInt32List(int tag, byte[] data2, int position, int limit, Internal.ProtobufList<?> list2, Registers registers) {
        IntArrayList output = (IntArrayList)list2;
        position = ArrayDecoders.decodeVarint32(data2, position, registers);
        output.addInt(CodedInputStream.decodeZigZag32(registers.int1));
        while (position < limit) {
            int nextPosition = ArrayDecoders.decodeVarint32(data2, position, registers);
            if (tag != registers.int1) break;
            position = ArrayDecoders.decodeVarint32(data2, nextPosition, registers);
            output.addInt(CodedInputStream.decodeZigZag32(registers.int1));
        }
        return position;
    }

    static int decodeSInt64List(int tag, byte[] data2, int position, int limit, Internal.ProtobufList<?> list2, Registers registers) {
        LongArrayList output = (LongArrayList)list2;
        position = ArrayDecoders.decodeVarint64(data2, position, registers);
        output.addLong(CodedInputStream.decodeZigZag64(registers.long1));
        while (position < limit) {
            int nextPosition = ArrayDecoders.decodeVarint32(data2, position, registers);
            if (tag != registers.int1) break;
            position = ArrayDecoders.decodeVarint64(data2, nextPosition, registers);
            output.addLong(CodedInputStream.decodeZigZag64(registers.long1));
        }
        return position;
    }

    static int decodePackedVarint32List(byte[] data2, int position, Internal.ProtobufList<?> list2, Registers registers) throws IOException {
        IntArrayList output = (IntArrayList)list2;
        position = ArrayDecoders.decodeVarint32(data2, position, registers);
        int fieldLimit = position + registers.int1;
        while (position < fieldLimit) {
            position = ArrayDecoders.decodeVarint32(data2, position, registers);
            output.addInt(registers.int1);
        }
        if (position != fieldLimit) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return position;
    }

    static int decodePackedVarint64List(byte[] data2, int position, Internal.ProtobufList<?> list2, Registers registers) throws IOException {
        LongArrayList output = (LongArrayList)list2;
        position = ArrayDecoders.decodeVarint32(data2, position, registers);
        int fieldLimit = position + registers.int1;
        while (position < fieldLimit) {
            position = ArrayDecoders.decodeVarint64(data2, position, registers);
            output.addLong(registers.long1);
        }
        if (position != fieldLimit) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return position;
    }

    static int decodePackedFixed32List(byte[] data2, int position, Internal.ProtobufList<?> list2, Registers registers) throws IOException {
        IntArrayList output = (IntArrayList)list2;
        int fieldLimit = position + registers.int1;
        for (position = ArrayDecoders.decodeVarint32(data2, position, registers); position < fieldLimit; position += 4) {
            output.addInt(ArrayDecoders.decodeFixed32(data2, position));
        }
        if (position != fieldLimit) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return position;
    }

    static int decodePackedFixed64List(byte[] data2, int position, Internal.ProtobufList<?> list2, Registers registers) throws IOException {
        LongArrayList output = (LongArrayList)list2;
        int fieldLimit = position + registers.int1;
        for (position = ArrayDecoders.decodeVarint32(data2, position, registers); position < fieldLimit; position += 8) {
            output.addLong(ArrayDecoders.decodeFixed64(data2, position));
        }
        if (position != fieldLimit) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return position;
    }

    static int decodePackedFloatList(byte[] data2, int position, Internal.ProtobufList<?> list2, Registers registers) throws IOException {
        FloatArrayList output = (FloatArrayList)list2;
        int fieldLimit = position + registers.int1;
        for (position = ArrayDecoders.decodeVarint32(data2, position, registers); position < fieldLimit; position += 4) {
            output.addFloat(ArrayDecoders.decodeFloat(data2, position));
        }
        if (position != fieldLimit) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return position;
    }

    static int decodePackedDoubleList(byte[] data2, int position, Internal.ProtobufList<?> list2, Registers registers) throws IOException {
        DoubleArrayList output = (DoubleArrayList)list2;
        int fieldLimit = position + registers.int1;
        for (position = ArrayDecoders.decodeVarint32(data2, position, registers); position < fieldLimit; position += 8) {
            output.addDouble(ArrayDecoders.decodeDouble(data2, position));
        }
        if (position != fieldLimit) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return position;
    }

    static int decodePackedBoolList(byte[] data2, int position, Internal.ProtobufList<?> list2, Registers registers) throws IOException {
        BooleanArrayList output = (BooleanArrayList)list2;
        position = ArrayDecoders.decodeVarint32(data2, position, registers);
        int fieldLimit = position + registers.int1;
        while (position < fieldLimit) {
            position = ArrayDecoders.decodeVarint64(data2, position, registers);
            output.addBoolean(registers.long1 != 0L);
        }
        if (position != fieldLimit) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return position;
    }

    static int decodePackedSInt32List(byte[] data2, int position, Internal.ProtobufList<?> list2, Registers registers) throws IOException {
        IntArrayList output = (IntArrayList)list2;
        position = ArrayDecoders.decodeVarint32(data2, position, registers);
        int fieldLimit = position + registers.int1;
        while (position < fieldLimit) {
            position = ArrayDecoders.decodeVarint32(data2, position, registers);
            output.addInt(CodedInputStream.decodeZigZag32(registers.int1));
        }
        if (position != fieldLimit) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return position;
    }

    static int decodePackedSInt64List(byte[] data2, int position, Internal.ProtobufList<?> list2, Registers registers) throws IOException {
        LongArrayList output = (LongArrayList)list2;
        position = ArrayDecoders.decodeVarint32(data2, position, registers);
        int fieldLimit = position + registers.int1;
        while (position < fieldLimit) {
            position = ArrayDecoders.decodeVarint64(data2, position, registers);
            output.addLong(CodedInputStream.decodeZigZag64(registers.long1));
        }
        if (position != fieldLimit) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return position;
    }

    static int decodeStringList(int tag, byte[] data2, int position, int limit, Internal.ProtobufList<?> list2, Registers registers) throws InvalidProtocolBufferException {
        Internal.ProtobufList<?> output = list2;
        position = ArrayDecoders.decodeVarint32(data2, position, registers);
        int length = registers.int1;
        if (length < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (length == 0) {
            output.add("");
        } else {
            String value = new String(data2, position, length, Internal.UTF_8);
            output.add(value);
            position += length;
        }
        while (position < limit) {
            int nextPosition = ArrayDecoders.decodeVarint32(data2, position, registers);
            if (tag != registers.int1) break;
            position = ArrayDecoders.decodeVarint32(data2, nextPosition, registers);
            int nextLength = registers.int1;
            if (nextLength < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            if (nextLength == 0) {
                output.add("");
                continue;
            }
            String value = new String(data2, position, nextLength, Internal.UTF_8);
            output.add(value);
            position += nextLength;
        }
        return position;
    }

    static int decodeStringListRequireUtf8(int tag, byte[] data2, int position, int limit, Internal.ProtobufList<?> list2, Registers registers) throws InvalidProtocolBufferException {
        Internal.ProtobufList<?> output = list2;
        position = ArrayDecoders.decodeVarint32(data2, position, registers);
        int length = registers.int1;
        if (length < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (length == 0) {
            output.add("");
        } else {
            if (!Utf8.isValidUtf8(data2, position, position + length)) {
                throw InvalidProtocolBufferException.invalidUtf8();
            }
            String value = new String(data2, position, length, Internal.UTF_8);
            output.add(value);
            position += length;
        }
        while (position < limit) {
            int nextPosition = ArrayDecoders.decodeVarint32(data2, position, registers);
            if (tag != registers.int1) break;
            position = ArrayDecoders.decodeVarint32(data2, nextPosition, registers);
            int nextLength = registers.int1;
            if (nextLength < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            if (nextLength == 0) {
                output.add("");
                continue;
            }
            if (!Utf8.isValidUtf8(data2, position, position + nextLength)) {
                throw InvalidProtocolBufferException.invalidUtf8();
            }
            String value = new String(data2, position, nextLength, Internal.UTF_8);
            output.add(value);
            position += nextLength;
        }
        return position;
    }

    static int decodeBytesList(int tag, byte[] data2, int position, int limit, Internal.ProtobufList<?> list2, Registers registers) throws InvalidProtocolBufferException {
        Internal.ProtobufList<?> output = list2;
        position = ArrayDecoders.decodeVarint32(data2, position, registers);
        int length = registers.int1;
        if (length < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (length > data2.length - position) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        if (length == 0) {
            output.add(ByteString.EMPTY);
        } else {
            output.add(ByteString.copyFrom(data2, position, length));
            position += length;
        }
        while (position < limit) {
            int nextPosition = ArrayDecoders.decodeVarint32(data2, position, registers);
            if (tag != registers.int1) break;
            position = ArrayDecoders.decodeVarint32(data2, nextPosition, registers);
            int nextLength = registers.int1;
            if (nextLength < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            if (nextLength > data2.length - position) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            if (nextLength == 0) {
                output.add(ByteString.EMPTY);
                continue;
            }
            output.add(ByteString.copyFrom(data2, position, nextLength));
            position += nextLength;
        }
        return position;
    }

    static int decodeMessageList(Schema<?> schema, int tag, byte[] data2, int position, int limit, Internal.ProtobufList<?> list2, Registers registers) throws IOException {
        Internal.ProtobufList<?> output = list2;
        position = ArrayDecoders.decodeMessageField(schema, data2, position, limit, registers);
        output.add(registers.object1);
        while (position < limit) {
            int nextPosition = ArrayDecoders.decodeVarint32(data2, position, registers);
            if (tag != registers.int1) break;
            position = ArrayDecoders.decodeMessageField(schema, data2, nextPosition, limit, registers);
            output.add(registers.object1);
        }
        return position;
    }

    static int decodeGroupList(Schema schema, int tag, byte[] data2, int position, int limit, Internal.ProtobufList<?> list2, Registers registers) throws IOException {
        Internal.ProtobufList<?> output = list2;
        int endgroup = tag & 0xFFFFFFF8 | 4;
        position = ArrayDecoders.decodeGroupField(schema, data2, position, limit, endgroup, registers);
        output.add(registers.object1);
        while (position < limit) {
            int nextPosition = ArrayDecoders.decodeVarint32(data2, position, registers);
            if (tag != registers.int1) break;
            position = ArrayDecoders.decodeGroupField(schema, data2, nextPosition, limit, endgroup, registers);
            output.add(registers.object1);
        }
        return position;
    }

    static int decodeExtensionOrUnknownField(int tag, byte[] data2, int position, int limit, Object message, MessageLite defaultInstance, UnknownFieldSchema<UnknownFieldSetLite, UnknownFieldSetLite> unknownFieldSchema, Registers registers) throws IOException {
        int number = tag >>> 3;
        GeneratedMessageLite.GeneratedExtension<MessageLite, ?> extension2 = registers.extensionRegistry.findLiteExtensionByNumber(defaultInstance, number);
        if (extension2 == null) {
            return ArrayDecoders.decodeUnknownField(tag, data2, position, limit, MessageSchema.getMutableUnknownFields(message), registers);
        }
        FieldSet<GeneratedMessageLite.ExtensionDescriptor> unused2 = ((GeneratedMessageLite.ExtendableMessage)message).ensureExtensionsAreMutable();
        return ArrayDecoders.decodeExtension(tag, data2, position, limit, (GeneratedMessageLite.ExtendableMessage)message, extension2, unknownFieldSchema, registers);
    }

    static int decodeExtension(int tag, byte[] data2, int position, int limit, GeneratedMessageLite.ExtendableMessage<?, ?> message, GeneratedMessageLite.GeneratedExtension<?, ?> extension2, UnknownFieldSchema<UnknownFieldSetLite, UnknownFieldSetLite> unknownFieldSchema, Registers registers) throws IOException {
        block40: {
            int fieldNumber;
            FieldSet<GeneratedMessageLite.ExtensionDescriptor> extensions;
            block39: {
                extensions = message.extensions;
                fieldNumber = tag >>> 3;
                if (!extension2.descriptor.isRepeated() || !extension2.descriptor.isPacked()) break block39;
                switch (extension2.getLiteType()) {
                    case DOUBLE: {
                        DoubleArrayList list2 = new DoubleArrayList();
                        position = ArrayDecoders.decodePackedDoubleList(data2, position, list2, registers);
                        extensions.setField(extension2.descriptor, list2);
                        break block40;
                    }
                    case FLOAT: {
                        FloatArrayList list3 = new FloatArrayList();
                        position = ArrayDecoders.decodePackedFloatList(data2, position, list3, registers);
                        extensions.setField(extension2.descriptor, list3);
                        break block40;
                    }
                    case INT64: 
                    case UINT64: {
                        LongArrayList list4 = new LongArrayList();
                        position = ArrayDecoders.decodePackedVarint64List(data2, position, list4, registers);
                        extensions.setField(extension2.descriptor, list4);
                        break block40;
                    }
                    case INT32: 
                    case UINT32: {
                        IntArrayList list5 = new IntArrayList();
                        position = ArrayDecoders.decodePackedVarint32List(data2, position, list5, registers);
                        extensions.setField(extension2.descriptor, list5);
                        break block40;
                    }
                    case FIXED64: 
                    case SFIXED64: {
                        LongArrayList list6 = new LongArrayList();
                        position = ArrayDecoders.decodePackedFixed64List(data2, position, list6, registers);
                        extensions.setField(extension2.descriptor, list6);
                        break block40;
                    }
                    case FIXED32: 
                    case SFIXED32: {
                        IntArrayList list7 = new IntArrayList();
                        position = ArrayDecoders.decodePackedFixed32List(data2, position, list7, registers);
                        extensions.setField(extension2.descriptor, list7);
                        break block40;
                    }
                    case BOOL: {
                        BooleanArrayList list8 = new BooleanArrayList();
                        position = ArrayDecoders.decodePackedBoolList(data2, position, list8, registers);
                        extensions.setField(extension2.descriptor, list8);
                        break block40;
                    }
                    case SINT32: {
                        IntArrayList list9 = new IntArrayList();
                        position = ArrayDecoders.decodePackedSInt32List(data2, position, list9, registers);
                        extensions.setField(extension2.descriptor, list9);
                        break block40;
                    }
                    case SINT64: {
                        LongArrayList list10 = new LongArrayList();
                        position = ArrayDecoders.decodePackedSInt64List(data2, position, list10, registers);
                        extensions.setField(extension2.descriptor, list10);
                        break block40;
                    }
                    case ENUM: {
                        IntArrayList list11 = new IntArrayList();
                        position = ArrayDecoders.decodePackedVarint32List(data2, position, list11, registers);
                        SchemaUtil.filterUnknownEnumList(message, fieldNumber, (List<Integer>)list11, extension2.descriptor.getEnumType(), null, unknownFieldSchema);
                        extensions.setField(extension2.descriptor, list11);
                        break block40;
                    }
                    default: {
                        throw new IllegalStateException("Type cannot be packed: " + (Object)((Object)extension2.descriptor.getLiteType()));
                    }
                }
            }
            Object value = null;
            if (extension2.getLiteType() == WireFormat.FieldType.ENUM) {
                position = ArrayDecoders.decodeVarint32(data2, position, registers);
                Object enumValue = extension2.descriptor.getEnumType().findValueByNumber(registers.int1);
                if (enumValue == null) {
                    SchemaUtil.storeUnknownEnum(message, fieldNumber, registers.int1, null, unknownFieldSchema);
                    return position;
                }
                value = registers.int1;
            } else {
                switch (extension2.getLiteType()) {
                    case DOUBLE: {
                        value = ArrayDecoders.decodeDouble(data2, position);
                        position += 8;
                        break;
                    }
                    case FLOAT: {
                        value = Float.valueOf(ArrayDecoders.decodeFloat(data2, position));
                        position += 4;
                        break;
                    }
                    case INT64: 
                    case UINT64: {
                        position = ArrayDecoders.decodeVarint64(data2, position, registers);
                        value = registers.long1;
                        break;
                    }
                    case INT32: 
                    case UINT32: {
                        position = ArrayDecoders.decodeVarint32(data2, position, registers);
                        value = registers.int1;
                        break;
                    }
                    case FIXED64: 
                    case SFIXED64: {
                        value = ArrayDecoders.decodeFixed64(data2, position);
                        position += 8;
                        break;
                    }
                    case FIXED32: 
                    case SFIXED32: {
                        value = ArrayDecoders.decodeFixed32(data2, position);
                        position += 4;
                        break;
                    }
                    case BOOL: {
                        position = ArrayDecoders.decodeVarint64(data2, position, registers);
                        value = registers.long1 != 0L;
                        break;
                    }
                    case BYTES: {
                        position = ArrayDecoders.decodeBytes(data2, position, registers);
                        value = registers.object1;
                        break;
                    }
                    case SINT32: {
                        position = ArrayDecoders.decodeVarint32(data2, position, registers);
                        value = CodedInputStream.decodeZigZag32(registers.int1);
                        break;
                    }
                    case SINT64: {
                        position = ArrayDecoders.decodeVarint64(data2, position, registers);
                        value = CodedInputStream.decodeZigZag64(registers.long1);
                        break;
                    }
                    case STRING: {
                        position = ArrayDecoders.decodeString(data2, position, registers);
                        value = registers.object1;
                        break;
                    }
                    case GROUP: {
                        int endTag = fieldNumber << 3 | 4;
                        Schema<Class<?>> fieldSchema = Protobuf.getInstance().schemaFor(extension2.getMessageDefaultInstance().getClass());
                        if (extension2.isRepeated()) {
                            position = ArrayDecoders.decodeGroupField(fieldSchema, data2, position, limit, endTag, registers);
                            extensions.addRepeatedField(extension2.descriptor, registers.object1);
                        } else {
                            Class<?> oldValue = extensions.getField(extension2.descriptor);
                            if (oldValue == null) {
                                oldValue = fieldSchema.newInstance();
                                extensions.setField(extension2.descriptor, oldValue);
                            }
                            position = ArrayDecoders.mergeGroupField(oldValue, fieldSchema, data2, position, limit, endTag, registers);
                        }
                        return position;
                    }
                    case MESSAGE: {
                        Schema<Class<?>> fieldSchema = Protobuf.getInstance().schemaFor(extension2.getMessageDefaultInstance().getClass());
                        if (extension2.isRepeated()) {
                            position = ArrayDecoders.decodeMessageField(fieldSchema, data2, position, limit, registers);
                            extensions.addRepeatedField(extension2.descriptor, registers.object1);
                        } else {
                            Class<?> oldValue = extensions.getField(extension2.descriptor);
                            if (oldValue == null) {
                                oldValue = fieldSchema.newInstance();
                                extensions.setField(extension2.descriptor, oldValue);
                            }
                            position = ArrayDecoders.mergeMessageField(oldValue, fieldSchema, data2, position, limit, registers);
                        }
                        return position;
                    }
                    case ENUM: {
                        throw new IllegalStateException("Shouldn't reach here.");
                    }
                }
            }
            if (extension2.isRepeated()) {
                extensions.addRepeatedField(extension2.descriptor, value);
            } else {
                extensions.setField(extension2.descriptor, value);
            }
        }
        return position;
    }

    static int decodeUnknownField(int tag, byte[] data2, int position, int limit, UnknownFieldSetLite unknownFields, Registers registers) throws InvalidProtocolBufferException {
        if (WireFormat.getTagFieldNumber(tag) == 0) {
            throw InvalidProtocolBufferException.invalidTag();
        }
        switch (WireFormat.getTagWireType(tag)) {
            case 0: {
                position = ArrayDecoders.decodeVarint64(data2, position, registers);
                unknownFields.storeField(tag, registers.long1);
                return position;
            }
            case 5: {
                unknownFields.storeField(tag, ArrayDecoders.decodeFixed32(data2, position));
                return position + 4;
            }
            case 1: {
                unknownFields.storeField(tag, ArrayDecoders.decodeFixed64(data2, position));
                return position + 8;
            }
            case 2: {
                position = ArrayDecoders.decodeVarint32(data2, position, registers);
                int length = registers.int1;
                if (length < 0) {
                    throw InvalidProtocolBufferException.negativeSize();
                }
                if (length > data2.length - position) {
                    throw InvalidProtocolBufferException.truncatedMessage();
                }
                if (length == 0) {
                    unknownFields.storeField(tag, ByteString.EMPTY);
                } else {
                    unknownFields.storeField(tag, ByteString.copyFrom(data2, position, length));
                }
                return position + length;
            }
            case 3: {
                UnknownFieldSetLite child = UnknownFieldSetLite.newInstance();
                int endGroup = tag & 0xFFFFFFF8 | 4;
                int lastTag = 0;
                while (position < limit) {
                    position = ArrayDecoders.decodeVarint32(data2, position, registers);
                    lastTag = registers.int1;
                    if (lastTag == endGroup) break;
                    position = ArrayDecoders.decodeUnknownField(lastTag, data2, position, limit, child, registers);
                }
                if (position > limit || lastTag != endGroup) {
                    throw InvalidProtocolBufferException.parseFailure();
                }
                unknownFields.storeField(tag, child);
                return position;
            }
        }
        throw InvalidProtocolBufferException.invalidTag();
    }

    static int skipField(int tag, byte[] data2, int position, int limit, Registers registers) throws InvalidProtocolBufferException {
        if (WireFormat.getTagFieldNumber(tag) == 0) {
            throw InvalidProtocolBufferException.invalidTag();
        }
        switch (WireFormat.getTagWireType(tag)) {
            case 0: {
                position = ArrayDecoders.decodeVarint64(data2, position, registers);
                return position;
            }
            case 5: {
                return position + 4;
            }
            case 1: {
                return position + 8;
            }
            case 2: {
                position = ArrayDecoders.decodeVarint32(data2, position, registers);
                return position + registers.int1;
            }
            case 3: {
                int endGroup = tag & 0xFFFFFFF8 | 4;
                int lastTag = 0;
                while (position < limit) {
                    position = ArrayDecoders.decodeVarint32(data2, position, registers);
                    lastTag = registers.int1;
                    if (lastTag == endGroup) break;
                    position = ArrayDecoders.skipField(lastTag, data2, position, limit, registers);
                }
                if (position > limit || lastTag != endGroup) {
                    throw InvalidProtocolBufferException.parseFailure();
                }
                return position;
            }
        }
        throw InvalidProtocolBufferException.invalidTag();
    }

    static final class Registers {
        public int int1;
        public long long1;
        public Object object1;
        public final ExtensionRegistryLite extensionRegistry;

        Registers() {
            this.extensionRegistry = ExtensionRegistryLite.getEmptyRegistry();
        }

        Registers(ExtensionRegistryLite extensionRegistry) {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            this.extensionRegistry = extensionRegistry;
        }
    }
}

