/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tools;

import java.util.Collections;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreDatabaseRestoreInfo;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreDatabaseRestoreSettings;
import org.jkiss.dbeaver.ext.postgresql.tools.PostgreRestoreWizardPageSettings;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.registry.task.TaskPreferenceStore;
import org.jkiss.dbeaver.tasks.ui.nativetool.AbstractNativeImportExportWizard;
import org.jkiss.dbeaver.ui.UIUtils;

class PostgreRestoreWizard
extends AbstractNativeImportExportWizard<PostgreDatabaseRestoreSettings, PostgreDatabaseRestoreInfo> {
    private PostgreRestoreWizardPageSettings settingsPage;

    PostgreRestoreWizard(DBTTask task) {
        super(task);
    }

    PostgreRestoreWizard(PostgreDatabase database) {
        super(Collections.singletonList(database), PostgreMessages.wizard_restore_title);
        ((PostgreDatabaseRestoreSettings)this.getSettings()).setRestoreInfo(new PostgreDatabaseRestoreInfo(database));
    }

    public String getTaskTypeId() {
        return "pgDatabaseRestore";
    }

    public void saveTaskState(DBRRunnableContext runnableContext, DBTTask task, Map<String, Object> state) {
        if (this.settingsPage.getControl() != null) {
            this.settingsPage.saveState();
        }
        ((PostgreDatabaseRestoreSettings)this.getSettings()).saveSettings(runnableContext, (DBPPreferenceStore)new TaskPreferenceStore(state));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.settingsPage = new PostgreRestoreWizardPageSettings(this);
    }

    public void addPages() {
        this.addTaskConfigPages();
        this.addPage((IWizardPage)this.settingsPage);
        super.addPages();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.settingsPage) {
            return null;
        }
        return super.getNextPage(page);
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page == this.logPage) {
            return this.settingsPage;
        }
        return super.getPreviousPage(page);
    }

    public void onSuccess(long workTime) {
        UIUtils.showMessageBox((Shell)this.getShell(), (String)"Database restore", (String)("Restore '" + this.getObjectsName() + "'"), (int)2);
    }

    protected PostgreDatabaseRestoreSettings createSettings() {
        return new PostgreDatabaseRestoreSettings();
    }
}

