/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.anomalydetection;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.Visitor;
import com.amazon.randomcutforest.tree.IBoundingBoxView;
import com.amazon.randomcutforest.tree.INodeView;
import java.util.Arrays;

public abstract class AbstractScalarScoreVisitor
implements Visitor<Double> {
    public static final int DEFAULT_IGNORE_LEAF_MASS_THRESHOLD = 0;
    protected final float[] pointToScore;
    protected final int treeMass;
    protected boolean pointInsideBox;
    protected boolean[] coordInsideBox;
    protected IBoundingBoxView shadowBox = null;
    protected double score;
    protected boolean ignoreLeafEquals;
    protected int ignoreLeafMassThreshold;

    public AbstractScalarScoreVisitor(float[] pointToScore, int treeMass, int ignoreLeafMassThreshold) {
        this.pointToScore = Arrays.copyOf(pointToScore, pointToScore.length);
        this.treeMass = treeMass;
        this.pointInsideBox = false;
        this.score = 0.0;
        this.ignoreLeafEquals = ignoreLeafMassThreshold > 0;
        this.ignoreLeafMassThreshold = ignoreLeafMassThreshold;
        this.coordInsideBox = new boolean[pointToScore.length];
    }

    public AbstractScalarScoreVisitor(float[] pointToScore, int treeMass) {
        this(pointToScore, treeMass, 0);
    }

    @Override
    public Double getResult() {
        return CommonUtils.defaultScalarNormalizerFunction(this.score, this.treeMass);
    }

    @Override
    public void accept(INodeView node, int depthOfNode) {
        double probabilityOfSeparation;
        if (this.pointInsideBox) {
            return;
        }
        if (!this.ignoreLeafEquals) {
            probabilityOfSeparation = node.probailityOfSeparation(this.pointToScore);
            if (probabilityOfSeparation <= 0.0) {
                this.pointInsideBox = true;
                return;
            }
        } else {
            this.shadowBox = this.shadowBox == null ? node.getSiblingBoundingBox(this.pointToScore) : this.shadowBox.getMergedBox(node.getSiblingBoundingBox(this.pointToScore));
            probabilityOfSeparation = this.shadowBox.getRangeSum() <= 0.0 ? 1.0 : this.getProbabilityOfSeparation(this.shadowBox);
        }
        this.score = probabilityOfSeparation * this.scoreUnseen(depthOfNode, node.getMass()) + (1.0 - probabilityOfSeparation) * this.score;
    }

    @Override
    public void acceptLeaf(INodeView leafNode, int depthOfNode) {
        if (Arrays.equals(leafNode.getLeafPoint(), this.pointToScore) && (!this.ignoreLeafEquals || leafNode.getMass() > this.ignoreLeafMassThreshold)) {
            this.pointInsideBox = true;
            this.score = this.damp(leafNode.getMass(), this.treeMass) * this.scoreSeen(depthOfNode, leafNode.getMass());
        } else {
            this.score = this.scoreUnseen(depthOfNode, leafNode.getMass());
        }
    }

    protected abstract double scoreSeen(int var1, int var2);

    protected abstract double scoreUnseen(int var1, int var2);

    protected abstract double damp(int var1, int var2);

    protected double getProbabilityOfSeparation(IBoundingBoxView boundingBox) {
        double sumOfNewRange = 0.0;
        double sumOfDifferenceInRange = 0.0;
        for (int i = 0; i < this.pointToScore.length; ++i) {
            double maxVal = boundingBox.getMaxValue(i);
            double minVal = boundingBox.getMinValue(i);
            double oldRange = maxVal - minVal;
            if (!this.coordInsideBox[i]) {
                if (maxVal < (double)this.pointToScore[i]) {
                    maxVal = this.pointToScore[i];
                } else if (minVal > (double)this.pointToScore[i]) {
                    minVal = this.pointToScore[i];
                } else if (!this.ignoreLeafEquals) {
                    sumOfNewRange += oldRange;
                    this.coordInsideBox[i] = true;
                    continue;
                }
                double newRange = maxVal - minVal;
                sumOfNewRange += newRange;
                sumOfDifferenceInRange += newRange - oldRange;
                continue;
            }
            sumOfNewRange += oldRange;
        }
        if (sumOfNewRange <= 0.0) {
            throw new IllegalStateException("Sum of new range of merged box in scoring function is smaller than 0 for a non-leaf node. The sum of range of new bounding box is: " + sumOfNewRange);
        }
        return sumOfDifferenceInRange / sumOfNewRange;
    }

    @Override
    public boolean isConverged() {
        return this.pointInsideBox;
    }
}

