/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.geo;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LatLonShape;
import org.apache.lucene.document.LatLonShapeDocValues;
import org.apache.lucene.document.LatLonShapeDocValuesField;
import org.apache.lucene.geo.LatLonGeometry;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.util.BytesRef;
import org.opensearch.common.geo.GeoShapeUtils;
import org.opensearch.common.geo.ShapeDocValue;
import org.opensearch.geometry.Geometry;
import org.opensearch.geometry.Rectangle;
import org.opensearch.index.mapper.GeoShapeIndexer;
import org.opensearch.index.mapper.ParseContext;

public class GeoShapeDocValue
extends ShapeDocValue {
    private static final String FIELD_NAME = "missingField";
    private final LatLonShapeDocValues shapeDocValues;

    public GeoShapeDocValue(String fieldName, BytesRef bytesRef) {
        this(LatLonShape.createDocValueField((String)fieldName, (BytesRef)bytesRef));
    }

    public GeoShapeDocValue(LatLonShapeDocValuesField shapeDocValuesField) {
        this.centroid = new Centroid(shapeDocValuesField.getCentroid().getLat(), shapeDocValuesField.getCentroid().getLon());
        this.highestDimensionType = ShapeDocValue.ShapeType.fromShapeFieldType(shapeDocValuesField.getHighestDimensionType());
        this.boundingRectangle = new BoundingRectangle(shapeDocValuesField.getBoundingBox().maxLon, shapeDocValuesField.getBoundingBox().maxLat, shapeDocValuesField.getBoundingBox().minLon, shapeDocValuesField.getBoundingBox().minLat);
        this.shapeDocValues = LatLonShape.createLatLonShapeDocValues((BytesRef)shapeDocValuesField.binaryValue());
    }

    public static GeoShapeDocValue createGeometryDocValue(Geometry geometry) {
        GeoShapeIndexer shapeIndex = new GeoShapeIndexer(true, FIELD_NAME);
        List<IndexableField> indexableFields = shapeIndex.indexShape((ParseContext)null, shapeIndex.prepareForIndexing(geometry));
        Field[] fieldsArray = new Field[indexableFields.size()];
        fieldsArray = indexableFields.toArray(fieldsArray);
        LatLonShapeDocValuesField latLonShapeDocValuesField = LatLonShape.createDocValueField((String)FIELD_NAME, (Field[])fieldsArray);
        return new GeoShapeDocValue(latLonShapeDocValuesField);
    }

    @Override
    public Centroid getCentroid() {
        return (Centroid)this.centroid;
    }

    @Override
    public BoundingRectangle getBoundingRectangle() {
        return (BoundingRectangle)this.boundingRectangle;
    }

    public String toString() {
        return "BoundingRectangle(" + String.valueOf(this.boundingRectangle) + "), Centroid(" + String.valueOf(this.centroid) + "), HighestDimension(" + String.valueOf((Object)this.highestDimensionType) + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoShapeDocValue object = (GeoShapeDocValue)o;
        boolean isEqual = true;
        if (this.boundingRectangle != null) {
            isEqual = this.boundingRectangle.equals(object.getBoundingRectangle());
        }
        if (this.centroid != null) {
            boolean bl = isEqual = isEqual && this.centroid.equals(object.getCentroid());
        }
        if (this.highestDimensionType != null) {
            isEqual = isEqual && this.highestDimensionType == object.getHighestDimensionType();
        }
        return isEqual;
    }

    public int hashCode() {
        long temp = this.boundingRectangle != null ? (long)this.boundingRectangle.hashCode() : 0L;
        int result = Long.hashCode(temp);
        temp = this.centroid != null ? (long)this.centroid.hashCode() : 0L;
        result = 31 * result + Long.hashCode(temp);
        temp = this.highestDimensionType != null ? (long)this.highestDimensionType.hashCode() : 0L;
        result = 31 * result + Long.hashCode(temp);
        return result;
    }

    public boolean isIntersectingRectangle(Rectangle rectangle) {
        org.apache.lucene.geo.Rectangle luceneRectangle = GeoShapeUtils.toLuceneRectangle(rectangle);
        try {
            PointValues.Relation relation = this.shapeDocValues.relate(LatLonGeometry.create((LatLonGeometry[])new LatLonGeometry[]{luceneRectangle}));
            return relation != PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static final class Centroid
    extends ShapeDocValue.Centroid {
        Centroid(double lat, double lon) {
            super(lat, lon);
        }

        public double getLatitude() {
            return this.getY();
        }

        public double getLongitude() {
            return this.getX();
        }

        @Override
        public String toString() {
            return this.getY() + ", " + this.getX();
        }
    }

    public static final class BoundingRectangle
    extends ShapeDocValue.BoundingRectangle {
        BoundingRectangle(double maxLon, double maxLat, double minLon, double minLat) {
            super(maxLon, maxLat, minLon, minLat);
        }

        public double getMaxLongitude() {
            return this.getMaxX();
        }

        public double getMaxLatitude() {
            return this.getMaxY();
        }

        public double getMinLatitude() {
            return this.getMinY();
        }

        public double getMinLongitude() {
            return this.getMinX();
        }

        @Override
        public String toString() {
            return "maxLatitude: " + this.getMaxY() + ", minLatitude: " + this.getMinY() + ", maxLongitude: " + this.getMaxX() + ", minLongitude: " + this.getMinX();
        }
    }
}

