/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.osm.edit;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.osmand.data.LatLon;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.OSMSettings;
import net.osmand.osm.edit.Relation;
import net.osmand.osm.edit.Way;

public abstract class Entity
implements Serializable {
    private Map<String, String> tags = null;
    private final long id;
    private boolean dataLoaded;
    private int modify;
    public static final int MODIFY_UNKNOWN = 0;
    public static final int MODIFY_DELETED = -1;
    public static final int MODIFY_MODIFIED = 1;
    public static final int MODIFY_CREATED = 2;

    public Entity(long id2) {
        this.id = id2;
    }

    public Entity(Entity copy, long id2) {
        this.id = id2;
        for (String t : copy.getTagKeySet()) {
            this.putTag(t, copy.getTag(t));
        }
        this.dataLoaded = copy.dataLoaded;
    }

    public int getModify() {
        return this.modify;
    }

    public void setModify(int modify) {
        this.modify = modify;
    }

    public long getId() {
        return this.id;
    }

    public String removeTag(String key) {
        if (this.tags != null) {
            return this.tags.remove(key);
        }
        return null;
    }

    public void removeTags(String ... keys) {
        if (this.tags != null) {
            for (String key : keys) {
                this.tags.remove(key);
            }
        }
    }

    public String putTag(String key, String value) {
        if (this.tags == null) {
            this.tags = new LinkedHashMap<String, String>();
        }
        return this.tags.put(key.toLowerCase(), value);
    }

    public void replaceTags(Map<String, String> toPut) {
        this.tags = new LinkedHashMap<String, String>(toPut);
    }

    public String getTag(OSMSettings.OSMTagKey key) {
        return this.getTag(key.getValue());
    }

    public String getTag(String key) {
        if (this.tags == null) {
            return null;
        }
        return this.tags.get(key);
    }

    public Map<String, String> getTags() {
        if (this.tags == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.tags);
    }

    public Collection<String> getTagKeySet() {
        if (this.tags == null) {
            return Collections.emptyList();
        }
        return this.tags.keySet();
    }

    public abstract void initializeLinks(Map<EntityId, Entity> var1);

    public abstract LatLon getLatLon();

    public boolean isVirtual() {
        return this.id < 0L;
    }

    public String getOsmUrl() {
        return EntityId.valueOf(this).getOsmUrl();
    }

    public String toString() {
        return EntityId.valueOf(this).toString();
    }

    public int hashCode() {
        if (this.id < 0L) {
            return System.identityHashCode(this);
        }
        return (int)this.id;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Entity other = (Entity)obj;
        if (this.id != other.id) {
            return false;
        }
        return this.id >= 0L;
    }

    public Set<String> getIsInNames() {
        String values = this.getTag(OSMSettings.OSMTagKey.IS_IN);
        if (values == null) {
            return Collections.emptySet();
        }
        if (values.indexOf(59) != -1) {
            String[] splitted = values.split(";");
            HashSet<String> set = new HashSet<String>(splitted.length);
            for (int i = 0; i < splitted.length; ++i) {
                set.add(splitted[i].trim());
            }
            return set;
        }
        return Collections.singleton(values.trim());
    }

    public void entityDataLoaded() {
        this.dataLoaded = true;
    }

    public boolean isDataLoaded() {
        return this.dataLoaded;
    }

    public Map<String, String> getModifiableTags() {
        if (this.tags == null) {
            return Collections.emptyMap();
        }
        return this.tags;
    }

    public static class EntityId {
        private final EntityType type;
        private final Long id;

        public EntityId(EntityType type, Long id2) {
            this.type = type;
            this.id = id2;
        }

        public static EntityId valueOf(Entity e) {
            return new EntityId(EntityType.valueOf(e), e.getId());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public String toString() {
            return (Object)((Object)this.type) + " " + this.id;
        }

        public EntityType getType() {
            return this.type;
        }

        public Long getId() {
            return this.id;
        }

        public String getOsmUrl() {
            String browseUrl = "https://www.openstreetmap.org/browse/";
            if (this.type == EntityType.NODE) {
                return "https://www.openstreetmap.org/browse/node/" + this.id;
            }
            if (this.type == EntityType.WAY) {
                return "https://www.openstreetmap.org/browse/way/" + this.id;
            }
            return null;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EntityId other = (EntityId)obj;
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals((Object)other.type));
        }
    }

    public static enum EntityType {
        NODE,
        WAY,
        RELATION,
        WAY_BOUNDARY;


        public static EntityType valueOf(Entity e) {
            if (e instanceof Node) {
                return NODE;
            }
            if (e instanceof Way) {
                return WAY;
            }
            if (e instanceof Relation) {
                return RELATION;
            }
            return null;
        }
    }
}

