﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/s3control/S3Control_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace S3Control {
namespace Model {
class DeleteMultiRegionAccessPointResult {
 public:
  AWS_S3CONTROL_API DeleteMultiRegionAccessPointResult() = default;
  AWS_S3CONTROL_API DeleteMultiRegionAccessPointResult(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_S3CONTROL_API DeleteMultiRegionAccessPointResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>The request token associated with the request. You can use this token with <a
   * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html">DescribeMultiRegionAccessPointOperation</a>
   * to determine the status of asynchronous requests.</p>
   */
  inline const Aws::String& GetRequestTokenARN() const { return m_requestTokenARN; }
  template <typename RequestTokenARNT = Aws::String>
  void SetRequestTokenARN(RequestTokenARNT&& value) {
    m_requestTokenARNHasBeenSet = true;
    m_requestTokenARN = std::forward<RequestTokenARNT>(value);
  }
  template <typename RequestTokenARNT = Aws::String>
  DeleteMultiRegionAccessPointResult& WithRequestTokenARN(RequestTokenARNT&& value) {
    SetRequestTokenARN(std::forward<RequestTokenARNT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * AWS Request Id value
   */
  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DeleteMultiRegionAccessPointResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * x-amz-id-2 header value, also known as Host Id
   */
  inline const Aws::String& GetHostId() const { return m_hostId; }
  template <typename HostIdT = Aws::String>
  void SetHostId(HostIdT&& value) {
    m_hostIdHasBeenSet = true;
    m_hostId = std::forward<HostIdT>(value);
  }
  template <typename HostIdT = Aws::String>
  DeleteMultiRegionAccessPointResult& WithHostId(HostIdT&& value) {
    SetHostId(std::forward<HostIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_requestTokenARN;

  Aws::String m_requestId;

  Aws::String m_hostId;
  bool m_requestTokenARNHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
  bool m_hostIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace S3Control
}  // namespace Aws
