/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.pattern;

import java.util.Map;
import org.apache.lucene.analysis.TokenizerFactory;
import org.apache.lucene.analysis.pattern.SimplePatternSplitTokenizer;
import org.apache.lucene.util.AttributeFactory;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.RegExp;

public class SimplePatternSplitTokenizerFactory
extends TokenizerFactory {
    public static final String NAME = "simplePatternSplit";
    public static final String PATTERN = "pattern";
    private final Automaton dfa;
    private final int determinizeWorkLimit;

    public SimplePatternSplitTokenizerFactory(Map<String, String> args) {
        super(args);
        this.determinizeWorkLimit = this.getInt(args, "determinizeWorkLimit", 10000);
        this.dfa = Operations.determinize(new RegExp(this.require(args, PATTERN)).toAutomaton(), this.determinizeWorkLimit);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + String.valueOf(args));
        }
    }

    public SimplePatternSplitTokenizerFactory() {
        throw SimplePatternSplitTokenizerFactory.defaultCtorException();
    }

    @Override
    public SimplePatternSplitTokenizer create(AttributeFactory factory) {
        return new SimplePatternSplitTokenizer(factory, this.dfa);
    }
}

