/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.USerializableInspectionBase;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.JvmValue;
import com.intellij.lang.jvm.actions.AnnotationAttributeRequest;
import com.intellij.lang.jvm.actions.AnnotationRequestsKt;
import com.intellij.lang.jvm.actions.CreateFieldRequest;
import com.intellij.lang.jvm.actions.ExpectedTypesKt;
import com.intellij.lang.jvm.actions.FieldRequestsKt;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.lang.jvm.types.JvmSubstitutor;
import com.intellij.lang.jvm.types.JvmType;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJvmSubstitutor;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.fixes.SerialVersionUIDBuilder;
import com.siyeh.ig.psiutils.SerializationUtils;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J+\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/codeInspection/SerializableHasSerialVersionUidFieldInspection;", "Lcom/intellij/codeInspection/USerializableInspectionBase;", "<init>", "()V", "getID", "", "checkClass", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "aClass", "Lorg/jetbrains/uast/UClass;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lorg/jetbrains/uast/UClass;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "createFix", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "psiClass", "Lcom/intellij/psi/PsiClass;", "intellij.jvm.analysis.impl"})
@SourceDebugExtension(value={"SMAP\nSerializableHasSerialVersionUidFieldInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SerializableHasSerialVersionUidFieldInspection.kt\ncom/intellij/codeInspection/SerializableHasSerialVersionUidFieldInspection\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,64:1\n37#2,2:65\n*S KotlinDebug\n*F\n+ 1 SerializableHasSerialVersionUidFieldInspection.kt\ncom/intellij/codeInspection/SerializableHasSerialVersionUidFieldInspection\n*L\n39#1:65,2\n*E\n"})
public final class SerializableHasSerialVersionUidFieldInspection
extends USerializableInspectionBase {
    public SerializableHasSerialVersionUidFieldInspection() {
        Class[] classArray = new Class[]{UClass.class};
        super(classArray);
    }

    @NotNull
    public String getID() {
        return "serial";
    }

    @NotNull
    public ProblemDescriptor[] checkClass(@NotNull UClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        LocalQuickFix[] localQuickFixArray;
        Intrinsics.checkNotNullParameter((Object)aClass, (String)"aClass");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        PsiClass psiClass = aClass.getJavaPsi();
        if (psiClass.isInterface() || psiClass.isAnnotationType() || psiClass.isEnum() || psiClass.isRecord()) {
            return new ProblemDescriptor[0];
        }
        if (psiClass instanceof PsiTypeParameter || psiClass instanceof PsiEnumConstantInitializer) {
            return new ProblemDescriptor[0];
        }
        if (this.ignoreAnonymousInnerClasses && psiClass instanceof PsiAnonymousClass) {
            return new ProblemDescriptor[0];
        }
        PsiField serialVersionUIDField = psiClass.findFieldByName("serialVersionUID", false);
        if (serialVersionUIDField != null) {
            return new ProblemDescriptor[0];
        }
        if (!SerializationUtils.isSerializable((PsiClass)psiClass)) {
            return new ProblemDescriptor[0];
        }
        if (SerializationUtils.hasWriteReplace((PsiClass)psiClass)) {
            return new ProblemDescriptor[0];
        }
        if (this.isIgnoredSubclass(psiClass)) {
            return new ProblemDescriptor[0];
        }
        PsiElement psiElement = UElementKt.getSourcePsiElement((UElement)aClass.getUastAnchor());
        if (psiElement == null) {
            return new ProblemDescriptor[0];
        }
        PsiElement identifier = psiElement;
        String message = JvmAnalysisBundle.message("jvm.inspections.serializable.class.without.serialversionuid.problem.descriptor", new Object[0]);
        ProblemDescriptor[] problemDescriptorArray = new ProblemDescriptor[1];
        if (isOnTheFly) {
            Collection $this$toTypedArray$iv = this.createFix(psiClass);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            localQuickFixArray = thisCollection$iv.toArray(new LocalQuickFix[0]);
        } else {
            localQuickFixArray = null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)manager.createProblemDescriptor(identifier, message, isOnTheFly, localQuickFixArray, ProblemHighlightType.GENERIC_ERROR_OR_WARNING), (String)"createProblemDescriptor(...)");
        return problemDescriptorArray;
    }

    private final List<LocalQuickFix> createFix(PsiClass psiClass) {
        long serialUid = SerialVersionUIDBuilder.computeDefaultSUID((PsiClass)psiClass);
        Project project = psiClass.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        List annotations = PsiUtil.isAvailable((JavaFeature)JavaFeature.SERIAL_ANNOTATION, (PsiElement)((PsiElement)psiClass)) ? CollectionsKt.listOf((Object)AnnotationRequestsKt.annotationRequest((String)"java.io.Serial", (AnnotationAttributeRequest[])new AnnotationAttributeRequest[0])) : CollectionsKt.emptyList();
        JvmClass jvmClass = (JvmClass)psiClass;
        Collection collection = annotations;
        Object[] objectArray = new JvmModifier[]{JvmModifier.PRIVATE, JvmModifier.STATIC};
        Collection collection2 = CollectionsKt.listOf((Object[])objectArray);
        PsiPrimitiveType psiPrimitiveType = PsiTypes.longType();
        Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType, (String)"longType(...)");
        List actions = JvmElementActionFactories.createAddFieldActions((JvmClass)jvmClass, (CreateFieldRequest)FieldRequestsKt.fieldRequest((String)"serialVersionUID", (Collection)collection, (Collection)collection2, (List)ExpectedTypesKt.expectedTypes$default((JvmType)((JvmType)psiPrimitiveType), null, (int)2, null), (JvmSubstitutor)((JvmSubstitutor)new PsiJvmSubstitutor(project2, PsiSubstitutor.EMPTY)), (JvmValue)((JvmValue)JvmValue.createLongValue((long)serialUid)), (boolean)true));
        List list = IntentionWrapper.wrapToQuickFixes((List)actions, (PsiFile)psiClass.getContainingFile());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"wrapToQuickFixes(...)");
        return list;
    }
}

