/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n.folding;

import com.intellij.codeInspection.i18n.folding.PropertyFoldingBuilder;
import com.intellij.lang.properties.IProperty;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.expressions.UInjectionHost;

public class PropertyFoldingEditHandler {
    private final UCallExpression myCallExpression;
    private final IProperty myProperty;

    PropertyFoldingEditHandler(PsiElement foldedPsiElement) {
        UInjectionHost injectionHost = null;
        if (foldedPsiElement != null && foldedPsiElement.isValid()) {
            this.myCallExpression = PropertyFoldingEditHandler.findCallExpression(foldedPsiElement);
            injectionHost = this.myCallExpression == null ? (UInjectionHost)UastContextKt.toUElementOfExpectedTypes((PsiElement)foldedPsiElement, (Class[])new Class[]{UInjectionHost.class}) : (UInjectionHost)ObjectUtils.tryCast((Object)this.myCallExpression.getArgumentForParameter(0), UInjectionHost.class);
        } else {
            this.myCallExpression = null;
        }
        this.myProperty = injectionHost == null ? null : PropertyFoldingBuilder.getI18nProperty(injectionHost);
    }

    private static UCallExpression findCallExpression(PsiElement foldedPsiElement) {
        UCallExpression expression = (UCallExpression)UastContextKt.toUElement((PsiElement)foldedPsiElement, UCallExpression.class);
        if (expression != null) {
            return expression;
        }
        for (PsiElement child = foldedPsiElement.getFirstChild(); child != null; child = child.getNextSibling()) {
            UCallExpression e = (UCallExpression)UastContextKt.toUElement((PsiElement)child, UCallExpression.class);
            if (e == null) continue;
            return e;
        }
        return null;
    }

    public boolean isValid() {
        return this.myProperty != null && this.myProperty.getPsiElement().isValid() && (this.myCallExpression == null || this.myCallExpression.isPsiValid());
    }

    public VirtualFile getFile() {
        PsiFile file = this.getPsiFile();
        return file == null ? null : file.getVirtualFile();
    }

    public PsiFile getPsiFile() {
        return this.myProperty.getPsiElement().getContainingFile();
    }

    public String getKey() {
        return this.myProperty.getKey();
    }

    public String getValue() {
        return this.myProperty.getValue();
    }

    public String getPlaceholder() {
        return this.myCallExpression == null ? "\"" + this.getValue() + "\"" : (String)PropertyFoldingBuilder.format((UCallExpression)this.myCallExpression).first;
    }

    public void setValue(String newValue) {
        this.myProperty.setValue(newValue);
    }

    int placeholderToValueOffset(int offset) {
        if (this.myCallExpression == null) {
            return offset - 1;
        }
        List replacements = (List)PropertyFoldingBuilder.format((UCallExpression)this.myCallExpression).second;
        if (replacements == null) {
            return offset - 1;
        }
        Iterator it = replacements.iterator();
        int diff = 0;
        while (it.hasNext()) {
            Couple start = (Couple)it.next();
            Couple end = (Couple)it.next();
            if (offset <= (Integer)start.second) {
                return offset + (Integer)start.first - (Integer)start.second - 1;
            }
            if (offset < (Integer)end.second) {
                return (Integer)end.first - 2;
            }
            diff = (Integer)end.second - (Integer)end.first;
        }
        return offset - diff - 1;
    }

    int valueToPlaceholderOffset(int offset) {
        ++offset;
        if (this.myCallExpression == null) {
            return offset;
        }
        Pair<String, List<Couple<Integer>>> info = PropertyFoldingBuilder.format(this.myCallExpression);
        List replacements = (List)info.second;
        if (replacements == null) {
            return offset;
        }
        Iterator it = replacements.iterator();
        int diff = 0;
        while (it.hasNext()) {
            Couple start = (Couple)it.next();
            Couple end = (Couple)it.next();
            if (offset <= (Integer)start.first) {
                return offset - (Integer)start.first + (Integer)start.second;
            }
            if (offset < (Integer)end.first) {
                return (Integer)end.second - 1;
            }
            diff = (Integer)end.second - (Integer)end.first;
        }
        return offset + diff;
    }
}

